/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class PostgreSchemaManager
extends SQLObjectEditor<PostgreSchema, PostgreDatabase>
implements DBEObjectRenamer<PostgreSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<PostgreDatabase, PostgreSchema> getObjectsCache(PostgreSchema object) {
        return object.getDatabase().schemaCache;
    }

    protected PostgreSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new PostgreSchema((PostgreDatabase)container, "NewSchema", null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)command.getObject();
        StringBuilder script = new StringBuilder("CREATE SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema));
        try {
            PostgreRole owner = schema.getOwner(monitor);
            if (owner != null) {
                script.append("\nAUTHORIZATION ").append(DBUtils.getQuotedIdentifier((DBSObject)owner));
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", script.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename schema", "ALTER SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreSchema)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreSchema)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(DBECommandContext commandContext, PostgreSchema schema, String newName) throws DBException {
        this.processObjectRename(commandContext, schema, newName);
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreSchema, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)command.getObject();
        String comment = schema.getDescription();
        if (comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment schema", "COMMENT ON SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " IS " + SQLUtils.quoteString((DBSObject)schema, (String)comment)));
        }
    }
}

