/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJobArgument;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class OracleSchedulerJob
extends OracleSchemaObject
implements OracleStatefulObject,
DBPScriptObjectExt {
    private static final String CAT_SETTINGS = "Settings";
    private static final String CAT_STATISTICS = "Statistics";
    private static final String CAT_EVENTS = "Events";
    private static final String CAT_ADVANCED = "Advanced";
    private String owner;
    private String jobSubName;
    private String jobStyle;
    private String jobCreator;
    private String clientId;
    private String globalUid;
    private String programOwner;
    private String programName;
    private String jobType;
    private String jobAction;
    private long numberOfArguments;
    private String scheduleOwner;
    private String scheduleName;
    private String scheduleType;
    private String startDate;
    private String repeatInterval;
    private String eventQueueOwner;
    private String eventQueueName;
    private String eventQueueAgent;
    private String eventCondition;
    private String eventRule;
    private String fileWatcherOwner;
    private String fileWatcherName;
    private String endDate;
    private String jobClass;
    private String enabled;
    private String autoDrop;
    private String restartable;
    private String state;
    private int jobPriority;
    private long runCount;
    private long maxRuns;
    private long failureCount;
    private long maxFailures;
    private long retryCount;
    private String lastStartDate;
    private String lastRunDuration;
    private String nextRunDate;
    private String scheduleLimit;
    private String maxRunDuration;
    private String loggingLevel;
    private String stopOnWindowClose;
    private String instanceStickiness;
    private String raiseEvents;
    private String system;
    private String jobWeight;
    private String nlsEnv;
    private String source;
    private String numberOfDestinations;
    private String destinationOwner;
    private String destination;
    private String credentialOwner;
    private String credentialName;
    private String instanceId;
    private String deferredDrop;
    private String allowRunsInRestrictedMode;
    private String comments;
    private final ArgumentsCache argumentsCache = new ArgumentsCache();

    protected OracleSchedulerJob(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_NAME"), true);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.jobSubName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_SUBNAME");
        this.jobStyle = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_STYLE");
        this.jobCreator = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_CREATOR");
        this.clientId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_ID");
        this.globalUid = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"GLOBAL_UID");
        this.programOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_OWNER");
        this.programName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM_NAME");
        this.jobType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_TYPE");
        this.jobAction = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_ACTION");
        this.numberOfArguments = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUMBER_OF_ARGUMENTS");
        this.scheduleOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEDULE_OWNER");
        this.scheduleName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEDULE_NAME");
        this.scheduleType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEDULE_TYPE");
        this.startDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"START_DATE");
        this.repeatInterval = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REPEAT_INTERVAL");
        this.eventQueueOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_QUEUE_OWNER");
        this.eventQueueName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_QUEUE_NAME");
        this.eventQueueAgent = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_QUEUE_AGENT");
        this.eventCondition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_CONDITION");
        this.eventRule = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_RULE");
        this.fileWatcherOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FILE_WATCHER_OWNER");
        this.fileWatcherName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FILE_WATCHER_NAME");
        this.endDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"END_DATE");
        this.jobClass = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_CLASS");
        this.enabled = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENABLED");
        this.autoDrop = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"AUTO_DROP");
        this.restartable = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RESTARTABLE");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATE");
        this.jobPriority = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"JOB_PRIORITY");
        this.runCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RUN_COUNT");
        this.maxRuns = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_RUNS");
        this.failureCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FAILURE_COUNT");
        this.maxFailures = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_FAILURES");
        this.retryCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RETRY_COUNT");
        this.lastStartDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_START_DATE");
        this.lastRunDuration = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_RUN_DURATION");
        this.nextRunDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NEXT_RUN_DATE");
        this.scheduleLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEDULE_LIMIT");
        this.maxRunDuration = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MAX_RUN_DURATION");
        this.loggingLevel = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOGGING_LEVEL");
        this.stopOnWindowClose = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STOP_ON_WINDOW_CLOSE");
        this.instanceStickiness = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INSTANCE_STICKINESS");
        this.raiseEvents = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RAISE_EVENTS");
        this.system = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SYSTEM");
        this.jobWeight = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"JOB_WEIGHT");
        this.nlsEnv = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NLS_ENV");
        this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SOURCE");
        this.numberOfDestinations = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NUMBER_OF_DESTINATIONS");
        this.destinationOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DESTINATION_OWNER");
        this.destination = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DESTINATION");
        this.credentialOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CREDENTIAL_OWNER");
        this.credentialName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CREDENTIAL_NAME");
        this.instanceId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INSTANCE_ID");
        this.deferredDrop = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFERRED_DROP");
        this.allowRunsInRestrictedMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ALLOW_RUNS_IN_RESTRICTED_MODE");
        this.comments = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENTS");
    }

    @Property(category="Advanced", viewable=false, order=10)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=10)
    public String getJobSubName() {
        return this.jobSubName;
    }

    @Property(viewable=true, order=11)
    public String getJobStyle() {
        return this.jobStyle;
    }

    @Property(category="Advanced", viewable=false, order=12)
    public String getJobCreator() {
        return this.jobCreator;
    }

    @Property(category="Advanced", viewable=false, order=13)
    public String getClientId() {
        return this.clientId;
    }

    @Property(category="Advanced", viewable=false, order=14)
    public String getGlobalUid() {
        return this.globalUid;
    }

    @Property(category="Advanced", viewable=false, order=15)
    public String getProgramOwner() {
        return this.programOwner;
    }

    @Property(viewable=false, order=16)
    public String getProgramName() {
        return this.programName;
    }

    @Property(viewable=true, order=17)
    public String getJobType() {
        return this.jobType;
    }

    @Property(category="Settings", viewable=false, order=18)
    public String getJobAction() {
        return this.jobAction;
    }

    @Property(category="Settings", viewable=false, order=19)
    public long getNumberOfArguments() {
        return this.numberOfArguments;
    }

    @Property(category="Advanced", viewable=false, order=20)
    public String getScheduleOwner() {
        return this.scheduleOwner;
    }

    @Property(viewable=false, order=21)
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Property(viewable=true, order=22)
    public String getScheduleType() {
        return this.scheduleType;
    }

    @Property(viewable=true, order=23)
    public String getStartDate() {
        return this.startDate;
    }

    @Property(viewable=true, order=24)
    public String getRepeatInterval() {
        return this.repeatInterval;
    }

    @Property(viewable=true, order=32)
    public String getEndDate() {
        return this.endDate;
    }

    @Property(category="Events", viewable=false, order=25)
    public String getEventQueueOwner() {
        return this.eventQueueOwner;
    }

    @Property(category="Events", viewable=false, order=26)
    public String getEventQueueName() {
        return this.eventQueueName;
    }

    @Property(category="Events", viewable=false, order=27)
    public String getEventQueueAgent() {
        return this.eventQueueAgent;
    }

    @Property(category="Events", viewable=false, order=28)
    public String getEventCondition() {
        return this.eventCondition;
    }

    @Property(category="Events", viewable=false, order=29)
    public String getEventRule() {
        return this.eventRule;
    }

    @Property(category="Events", viewable=false, order=30)
    public String getFileWatcherOwner() {
        return this.fileWatcherOwner;
    }

    @Property(category="Events", viewable=false, order=31)
    public String getFileWatcherName() {
        return this.fileWatcherName;
    }

    @Property(viewable=false, order=33)
    public String getJobClass() {
        return this.jobClass;
    }

    @Property(category="Settings", viewable=false, order=34)
    public String getEnabled() {
        return this.enabled;
    }

    @Property(category="Settings", viewable=false, order=35)
    public String getAutoDrop() {
        return this.autoDrop;
    }

    @Property(category="Settings", viewable=false, order=36)
    public String getRestartable() {
        return this.restartable;
    }

    @Property(viewable=false, order=37)
    public String getState() {
        return this.state;
    }

    @Property(category="Settings", viewable=false, order=38)
    public int getJobPriority() {
        return this.jobPriority;
    }

    @Property(category="Statistics", viewable=false, order=39)
    public long getRunCount() {
        return this.runCount;
    }

    @Property(category="Statistics", viewable=false, order=40)
    public long getMaxRuns() {
        return this.maxRuns;
    }

    @Property(category="Statistics", viewable=false, order=41)
    public long getFailureCount() {
        return this.failureCount;
    }

    @Property(category="Statistics", viewable=false, order=42)
    public long getMaxFailures() {
        return this.maxFailures;
    }

    @Property(category="Statistics", viewable=false, order=43)
    public long getRetryCount() {
        return this.retryCount;
    }

    @Property(category="Statistics", viewable=false, order=44)
    public String getLastStartDate() {
        return this.lastStartDate;
    }

    @Property(category="Statistics", viewable=false, order=45)
    public String getLastRunDuration() {
        return this.lastRunDuration;
    }

    @Property(category="Settings", viewable=false, order=46)
    public String getNextRunDate() {
        return this.nextRunDate;
    }

    @Property(category="Settings", viewable=false, order=47)
    public String getScheduleLimit() {
        return this.scheduleLimit;
    }

    public String getMaxRunDuration() {
        return this.maxRunDuration;
    }

    @Property(category="Settings", viewable=false, order=49)
    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    @Property(category="Settings", viewable=false, order=50)
    public String getStopOnWindowClose() {
        return this.stopOnWindowClose;
    }

    @Property(category="Advanced", viewable=false, order=51)
    public String getInstanceStickiness() {
        return this.instanceStickiness;
    }

    @Property(category="Advanced", viewable=false, order=52)
    public String getRaiseEvents() {
        return this.raiseEvents;
    }

    @Property(category="Settings", viewable=false, order=53)
    public String getSystem() {
        return this.system;
    }

    @Property(category="Advanced", viewable=false, order=54)
    public String getJobWeight() {
        return this.jobWeight;
    }

    @Property(category="Advanced", viewable=false, order=55)
    public String getNlsEnv() {
        return this.nlsEnv;
    }

    @Property(category="Advanced", viewable=false, order=56)
    public String getSource() {
        return this.source;
    }

    public String getNumberOfDestinations() {
        return this.numberOfDestinations;
    }

    @Property(category="Advanced", viewable=false, order=58)
    public String getDestinationOwner() {
        return this.destinationOwner;
    }

    @Property(category="Advanced", viewable=false, order=59)
    public String getDestination() {
        return this.destination;
    }

    @Property(category="Advanced", viewable=false, order=60)
    public String getCredentialOwner() {
        return this.credentialOwner;
    }

    @Property(category="Advanced", viewable=false, order=61)
    public String getCredentialName() {
        return this.credentialName;
    }

    @Property(category="Advanced", viewable=false, order=62)
    public String getInstanceId() {
        return this.instanceId;
    }

    @Property(category="Advanced", viewable=false, order=63)
    public String getDeferredDrop() {
        return this.deferredDrop;
    }

    @Property(category="Advanced", viewable=false, order=64)
    public String getAllowRunsInRestrictedMode() {
        return this.allowRunsInRestrictedMode;
    }

    @Override
    @Property(viewable=false, order=200)
    @Nullable
    public String getDescription() {
        return this.comments;
    }

    @Association
    public Collection<OracleSchedulerJobArgument> getArguments(DBRProgressMonitor monitor) throws DBException {
        return this.argumentsCache.getAllObjects(monitor, this);
    }

    public DBSObjectState getObjectState() {
        DBSObjectState objectState = null;
        try {
            objectState = JobState.valueOf(this.state).equals((Object)JobState.RUNNING) ? DBSObjectState.ACTIVE : (JobState.valueOf(this.state).equals((Object)JobState.BROKEN) ? DBSObjectState.INVALID : (JobState.valueOf(this.state).equals((Object)JobState.CHAIN_STALLED) ? DBSObjectState.INVALID : (JobState.valueOf(this.state).equals((Object)JobState.FAILED) ? DBSObjectState.INVALID : DBSObjectState.NORMAL)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectState = DBSObjectState.UNKNOWN;
        }
        return objectState;
    }

    public void refreshObjectState(DBRProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Load action for '" + this.getName() + "'...", 1);
            try {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Load action for " + (Object)((Object)OracleObjectType.JOB) + " '" + this.getName() + "'"));){
                        Throwable throwable2 = null;
                        Object var6_10 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT STATE FROM " + OracleUtils.getSysSchemaPrefix(this.getDataSource()) + "ALL_SCHEDULER_JOBS " + "WHERE OWNER=? AND JOB_NAME=? ");){
                            dbStat.setString(1, this.getOwner());
                            dbStat.setString(2, this.getName());
                            dbStat.setFetchSize(1000);
                            Throwable throwable3 = null;
                            Object var9_15 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                StringBuilder jobState = null;
                                int lineCount = 0;
                                while (dbResult.next()) {
                                    if (monitor.isCanceled()) break;
                                    String line = dbResult.getString(1);
                                    if (jobState == null) {
                                        jobState = new StringBuilder(15);
                                    }
                                    jobState.append(line);
                                    monitor.subTask("Line " + ++lineCount);
                                }
                                if (jobState != null) {
                                    this.state = jobState.toString();
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    monitor.subTask("Error refreshing job state " + e.getMessage());
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public DBEPersistAction[] getRunActions() {
        StringBuffer runScript = new StringBuffer();
        runScript.append("BEGIN\n");
        runScript.append("\tDBMS_SCHEDULER.RUN_JOB(JOB_NAME => '");
        runScript.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        runScript.append("', USE_CURRENT_SESSION => FALSE);");
        runScript.append("END;");
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.JOB, "Run Job", runScript.toString())};
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.jobAction == null && monitor != null) {
            monitor.beginTask("Load action for '" + this.getName() + "'...", 1);
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Load action for " + (Object)((Object)OracleObjectType.JOB) + " '" + this.getName() + "'"));){
                    try {
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT JOB_ACTION FROM " + OracleUtils.getSysSchemaPrefix(this.getDataSource()) + "ALL_SCHEDULER_JOBS " + "WHERE OWNER=? AND JOB_NAME=? ");){
                            dbStat.setString(1, this.getOwner());
                            dbStat.setString(2, this.getName());
                            dbStat.setFetchSize(1000);
                            Throwable throwable3 = null;
                            Object var10_16 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                StringBuilder action = null;
                                int lineCount = 0;
                                while (dbResult.next()) {
                                    if (monitor.isCanceled()) break;
                                    String line = dbResult.getString(1);
                                    if (action == null) {
                                        action = new StringBuilder(4000);
                                    }
                                    action.append(line);
                                    monitor.subTask("Line " + ++lineCount);
                                }
                                if (action != null) {
                                    this.jobAction = action.toString();
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.jobAction;
    }

    public String getExtendedDefinitionText(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    static class ArgumentsCache
    extends JDBCObjectCache<OracleSchedulerJob, OracleSchedulerJobArgument> {
        ArgumentsCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchedulerJob job) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix(job.getDataSource()) + "ALL_SCHEDULER_JOB_ARGS " + "WHERE OWNER=? AND JOB_NAME=? " + "ORDER BY ARGUMENT_POSITION");
            dbStat.setString(1, job.getSchema().getName());
            dbStat.setString(2, job.getName());
            return dbStat;
        }

        protected OracleSchedulerJobArgument fetchObject(@NotNull JDBCSession session, @NotNull OracleSchedulerJob job, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSchedulerJobArgument(job, (ResultSet)resultSet);
        }
    }

    static enum JobState {
        DISABLED,
        RETRYSCHEDULED,
        SCHEDULED,
        RUNNING,
        COMPLETED,
        BROKEN,
        FAILED,
        REMOTE,
        SUCCEEDED,
        CHAIN_STALLED;

    }
}

