/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.GenericFilterValueEdit;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;

public class FilterValueEditPopup
extends AbstractPopupPanel {
    private static final String DIALOG_ID = "DBeaver.FilterValueEditMenu";
    private Object value;
    private GenericFilterValueEdit filter;
    private Point location;

    public FilterValueEditPopup(Shell parentShell, @NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows) {
        super(parentShell, "Filter by '" + attr.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
        this.setShellStyle(1264);
        this.filter = new GenericFilterValueEdit(viewer, attr, rows, DBCLogicalOperator.IN);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createDialogArea(final Composite parent) {
        final DBSEntityReferrer descReferrer = ResultSetUtils.getEnumerableConstraint(this.filter.getAttribute());
        Composite group = (Composite)super.createDialogArea(parent);
        Composite labelComposite = UIUtils.createComposite((Composite)group, (int)2);
        labelComposite.setLayoutData((Object)new GridData(768));
        Label controlLabel = UIUtils.createControlLabel((Composite)labelComposite, (String)"Choose value(s) to filter by");
        controlLabel.setLayoutData((Object)new GridData(768));
        if (descReferrer instanceof DBSEntityAssociation) {
            Link hintLabel = UIUtils.createLink((Composite)labelComposite, (String)"(<a>Define Description</a>)", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(((DBSEntityAssociation)descReferrer).getAssociatedEntity());
                    if (editDictionaryPage.edit(parent.getShell())) {
                        FilterValueEditPopup.this.filter.loadValues(null);
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)labelComposite, (int)1, (int)1);
        }
        Text filterTextbox = this.filter.addFilterTextbox(group);
        filterTextbox.setFocus();
        filterTextbox.addTraverseListener(e -> {
            Table table = this.filter.getTableViewer().getTable();
            if (e.detail == 32 || e.detail == 64) {
                if (table.getSelectionIndex() < 0 && table.getItemCount() > 0) {
                    table.setSelection(0);
                }
                table.setFocus();
            } else if (e.detail == 4) {
                this.applyFilterValue();
            }
        });
        UIUtils.addEmptyTextHint((Control)filterTextbox, text -> "Type partial value to search");
        Composite tableComposite = UIUtils.createComposite((Composite)group, (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        tableComposite.setLayoutData((Object)gd);
        this.filter.setupTable(tableComposite, 0x10B04 | (this.filter.getOperator() == DBCLogicalOperator.IN ? 32 : 0), true, descReferrer != null, new GridData(1808));
        Table table = this.filter.getTableViewer().getTable();
        TableViewerColumn resultsetColumn = new TableViewerColumn(this.filter.getTableViewer(), UIUtils.createTableColumn((Table)table, (int)0, (String)"Value"));
        resultsetColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return FilterValueEditPopup.this.filter.getAttribute().getValueHandler().getValueDisplayString((DBSTypedObject)FilterValueEditPopup.this.filter.getAttribute(), ((DBDLabelValuePair)element).getValue(), DBDDisplayFormat.UI);
            }
        });
        if (descReferrer != null) {
            TableViewerColumn descColumn = new TableViewerColumn(this.filter.getTableViewer(), UIUtils.createTableColumn((Table)table, (int)0, (String)"Description"));
            descColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((DBDLabelValuePair)element).getLabel();
                }
            });
        }
        this.filter.getTableViewer().addSelectionChangedListener(event -> {
            this.value = this.filter.getFilterValue();
        });
        this.filter.getTableViewer().addDoubleClickListener(event -> this.applyFilterValue());
        this.filter.setFilterPattern(null);
        this.filter.loadValues(() -> UIUtils.asyncExec(() -> UIUtils.packColumns((Table)table, (boolean)false)));
        this.filter.createFilterButton(ResultSetMessages.sql_editor_resultset_filter_panel_btn_apply, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterValueEditPopup.this.applyFilterValue();
            }
        });
        this.closeOnFocusLost(new Control[]{filterTextbox, table});
        return tableComposite;
    }

    private void applyFilterValue() {
        this.value = this.filter.getFilterValue();
        this.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        return UIUtils.createPlaceholder((Composite)parent, (int)1);
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Object getValue() {
        return this.value;
    }
}

