/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.hana.model.HANADataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class HANAStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private HANADataSource dataSource;

    public HANAStructureAssistant(HANADataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_VIEW, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN};
    }

    protected void findObjectsByMask(JDBCExecutionContext executionContext, JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> result) throws DBException, SQLException {
        GenericSchema parentSchema;
        GenericSchema genericSchema = parentSchema = parentObject instanceof GenericSchema ? (GenericSchema)parentObject : null;
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW) {
            this.findViewsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW_COLUMN) {
            this.findViewColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
    }

    private void findTablesByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COMMENTS FROM SYS.TABLES WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " TABLE_NAME LIKE ?" : " UPPER(TABLE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, TABLE_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTable.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findViewsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COMMENTS FROM SYS.VIEWS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " VIEW_NAME LIKE ?" : " UPPER(VIEW_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, VIEW_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTable.class, RelationalObjectType.TYPE_VIEW){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, PROCEDURE_NAME FROM SYS.PROCEDURES WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " PROCEDURE_NAME LIKE ?" : " UPPER(PROCEDURE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, PROCEDURE_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = null;
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericProcedure object = ((GenericObjectContainer)this.getContainer()).getProcedure(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COLUMN_NAME, COMMENTS FROM SYS.TABLE_COLUMNS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, TABLE_NAME, COLUMN_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findViewColumnsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COLUMN_NAME, COMMENTS FROM SYS.VIEW_COLUMNS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, VIEW_NAME, COLUMN_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

