/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.browser.BrowserFactory;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.Trace;

public class BrowserExt
implements IBrowserExt {
    private static final String ATTR_FACTORY_CLASS = "factoryclass";
    private IConfigurationElement element;
    private BrowserFactory delegate;

    public BrowserExt(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getId() {
        return this.element.getAttribute("id");
    }

    @Override
    public String getName() {
        String label = this.element.getAttribute("name");
        if (label == null) {
            return "n/a";
        }
        return label;
    }

    @Override
    public String getParameters() {
        return this.element.getAttribute("parameters");
    }

    @Override
    public String getExecutable() {
        return this.element.getAttribute("executable");
    }

    @Override
    public String getOS() {
        String os = this.element.getAttribute("os");
        if (os == null) {
            os = "";
        }
        return os;
    }

    @Override
    public String[] getDefaultLocations() {
        ArrayList<String> list = new ArrayList<String>();
        IConfigurationElement[] children = this.element.getChildren("location");
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                list.add(children[i].getValue());
                ++i;
            }
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    protected BrowserFactory getDelegate() {
        if (this.delegate == null) {
            if (this.element.getAttribute(ATTR_FACTORY_CLASS) == null || this.element.getAttribute(ATTR_FACTORY_CLASS).length() == 0) {
                return null;
            }
            try {
                this.delegate = (BrowserFactory)this.element.createExecutableExtension(ATTR_FACTORY_CLASS);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not create delegate" + this + ": " + e.getMessage());
            }
        }
        return this.delegate;
    }

    @Override
    public boolean isAvailable() {
        if (this.delegate == null && (this.element.getAttribute(ATTR_FACTORY_CLASS) == null || this.element.getAttribute(ATTR_FACTORY_CLASS).length() == 0)) {
            return true;
        }
        try {
            return this.getDelegate().isAvailable();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public IWebBrowser createBrowser(String id, String location, String parameters) {
        try {
            return this.getDelegate().createBrowser(id, location, parameters);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this + ": " + e.getMessage());
            return null;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("BrowserExt: ").append(this.getId()).append(", " + this.getName()).append(", ").append(this.getOS()).append(", ").append(this.getExecutable()).append(", ").append(this.getParameters()).append(", ");
        String[] locations = this.getDefaultLocations();
        if (locations != null) {
            int size = locations.length;
            int i = 0;
            while (i < size) {
                s.append(locations[i]).append(";");
                ++i;
            }
        }
        return s.toString();
    }
}

