/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditPartFactory;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.utils.CommonUtils;

public class ERDDecoratorDefault
implements ERDDecorator {
    public static final ImageDescriptor CONNECT_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_ASSOCIATION);
    public static final ImageDescriptor FOREIGN_KEY_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_FOREIGN_KEY);
    public static final ImageDescriptor NOTE_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_TEXT);
    private static final Log log = Log.getLog(ERDDecoratorDefault.class);

    @Override
    public boolean showCheckboxes() {
        return false;
    }

    @Override
    public boolean allowEntityDuplicates() {
        return false;
    }

    @Override
    public boolean supportsAttributeVisibility() {
        return true;
    }

    @Override
    public Insets getDefaultEntityInsets() {
        return new Insets(20, 20, 10, 20);
    }

    @Override
    public EditPartFactory createPartFactory() {
        return new ERDEditPartFactory();
    }

    @Override
    public void fillPalette(PaletteRoot paletteRoot, boolean readOnly) {
        PaletteDrawer controls = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        controls.add((PaletteEntry)selectionTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
        if (!readOnly) {
            PaletteSeparator separator = new PaletteSeparator("tools");
            separator.setUserModificationPermission(1);
            controls.add((PaletteEntry)separator);
            controls.add((PaletteEntry)new ConnectionCreationToolEntry(ERDMessages.erd_tool_create_connection, ERDMessages.erd_tool_create_connection_tip, null, CONNECT_IMAGE, CONNECT_IMAGE));
            controls.add((PaletteEntry)new CreationToolEntry(ERDMessages.erd_tool_create_note, ERDMessages.erd_tool_create_note_tip, new CreationFactory(){

                public Object getNewObject() {
                    return new ERDNote(ERDMessages.erd_tool_create_default);
                }

                public Object getObjectType() {
                    return "create child";
                }
            }, NOTE_IMAGE, NOTE_IMAGE));
        }
    }

    protected PaletteDrawer createToolsDrawer(PaletteRoot paletteRoot) {
        PaletteDrawer controls = new PaletteDrawer("Tools", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        paletteRoot.add((PaletteEntry)controls);
        return controls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillEntityFromObject(DBRProgressMonitor monitor, EntityDiagram diagram, List<ERDEntity> otherEntities, ERDEntity erdEntity) {
        ERDAttributeVisibility attributeVisibility;
        DBSEntity entity = (DBSEntity)erdEntity.getObject();
        ERDAttributeVisibility eRDAttributeVisibility = attributeVisibility = diagram.getDecorator().supportsAttributeVisibility() ? erdEntity.getAttributeVisibility() : ERDAttributeVisibility.ALL;
        if (attributeVisibility == null) {
            EntityDiagram.NodeVisualInfo visualInfo = diagram.getVisualInfo((DBSEntity)erdEntity.getObject());
            if (visualInfo != null) {
                attributeVisibility = visualInfo.attributeVisibility;
            }
            if (attributeVisibility == null) {
                attributeVisibility = diagram.getAttributeVisibility();
            }
        }
        if (attributeVisibility == ERDAttributeVisibility.NONE) return;
        HashSet<? extends DBSEntityAttribute> keyColumns = new HashSet<DBSEntityAttribute>();
        try {
            for (DBSEntityAssociation assoc : DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(assoc instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)assoc)));
            }
            for (DBSEntityConstraint constraint : DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(constraint instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint)));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        Collection<? extends DBSEntityAttribute> idColumns = null;
        try {
            idColumns = ERDUtils.getBestTableIdentifier(monitor, entity);
            keyColumns.addAll(idColumns);
        }
        catch (DBException e) {
            log.error((Object)"Error reading table identifier", (Throwable)e);
        }
        try {
            List attributes = entity.getAttributes(monitor);
            DBSEntityAttribute firstAttr = CommonUtils.isEmpty((Collection)attributes) ? null : (DBSEntityAttribute)attributes.iterator().next();
            DBSObjectFilter columnFilter = firstAttr == null ? null : entity.getDataSource().getContainer().getObjectFilter(firstAttr.getClass(), (DBSObject)entity, false);
            if (CommonUtils.isEmpty((Collection)attributes)) return;
            block12: for (DBSEntityAttribute attribute : attributes) {
                boolean isInIdentifier;
                boolean bl = isInIdentifier = idColumns != null && idColumns.contains(attribute);
                if (!keyColumns.contains(attribute) && !this.isAttributeVisible(erdEntity, attribute) || columnFilter != null && !columnFilter.matches(attribute.getName())) continue;
                switch (attributeVisibility) {
                    case PRIMARY: {
                        if (isInIdentifier) break;
                        continue block12;
                    }
                    case KEYS: {
                        if (!keyColumns.contains(attribute)) continue block12;
                    }
                }
                boolean inPrimaryKey = idColumns != null && idColumns.contains(attribute);
                ERDEntityAttribute c1 = new ERDEntityAttribute(attribute, inPrimaryKey);
                erdEntity.addAttribute(c1, false);
            }
            return;
        }
        catch (DBException e) {
            log.debug((Object)("Can't load table '" + entity.getName() + "'attributes"), (Throwable)e);
        }
    }

    protected boolean isAttributeVisible(ERDEntity erdEntity, DBSEntityAttribute attribute) {
        if (attribute instanceof DBSEntityAssociation) {
            return false;
        }
        return !DBUtils.isHiddenObject((Object)attribute) && !DBUtils.isInheritedObject((Object)attribute);
    }

    @Override
    public ERDAssociation createAutoAssociation(ERDContainer diagram, DBSEntityAssociation association, ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        return new ERDAssociation(association, sourceEntity, targetEntity, reflect);
    }
}

