/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Menu;

public abstract class CompoundContributionItem
extends ContributionItem {
    private IMenuListener menuListener = manager -> manager.markDirty();
    private IContributionItem[] oldItems;

    protected CompoundContributionItem() {
    }

    protected CompoundContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (index == -1) {
            index = menu.getItemCount();
        }
        IContributionItem[] items = this.getContributionItemsToFill();
        if (index > menu.getItemCount()) {
            index = menu.getItemCount();
        }
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            int oldItemCount = menu.getItemCount();
            if (item.isVisible()) {
                item.fill(menu, index);
            }
            int newItemCount = menu.getItemCount();
            int numAdded = newItemCount - oldItemCount;
            index += numAdded;
            ++n2;
        }
    }

    protected abstract IContributionItem[] getContributionItems();

    private IContributionItem[] getContributionItemsToFill() {
        this.disposeOldItems();
        this.oldItems = this.getContributionItems();
        return this.oldItems;
    }

    private void disposeOldItems() {
        if (this.oldItems != null) {
            IContributionItem[] iContributionItemArray = this.oldItems;
            int n = this.oldItems.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem oldItem = iContributionItemArray[n2];
                oldItem.dispose();
                ++n2;
            }
            this.oldItems = null;
        }
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    public void dispose() {
        this.disposeOldItems();
        super.dispose();
    }
}

