/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKeyColumnTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyDeferability;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.utils.CommonUtils;

public abstract class GenericTableBase
extends JDBCTable<GenericDataSource, GenericStructContainer>
implements DBPRefreshableObject,
DBPSystemObject,
DBPScriptObject {
    private static final Log log = Log.getLog(GenericTableBase.class);
    private String tableType;
    private boolean isSystem;
    private String description;
    private Long rowCount;
    private List<? extends GenericTrigger> triggers;

    public GenericTableBase(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super((DBSObject)container, tableName, dbResult != null);
        this.tableType = tableType;
        if (this.tableType == null) {
            this.tableType = "";
        }
        if (dbResult != null) {
            this.description = GenericUtils.safeGetString(container.getTableCache().tableObject, (ResultSet)dbResult, "REMARKS");
        }
        GenericMetaModel metaModel = container.getDataSource().getMetaModel();
        this.isSystem = metaModel.isSystemTable(this);
    }

    public TableCache getCache() {
        return ((GenericStructContainer)this.getContainer()).getTableCache();
    }

    protected boolean isTruncateSupported() {
        return CommonUtils.getBoolean((Object)((GenericDataSource)this.getDataSource()).getContainer().getDriver().getDriverParameter("supports-truncate"), (boolean)false);
    }

    public GenericStructContainer getParentObject() {
        return ((GenericStructContainer)this.getContainer()).getObject();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.isView() && context == DBPEvaluationContext.DDL && !((GenericDataSource)this.getDataSource()).getMetaModel().useCatalogInObjectNames()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this.getSchema(), this});
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    @Property(viewable=true, order=2)
    public String getTableType() {
        return this.tableType;
    }

    @Property(viewable=true, optional=true, order=3)
    public GenericCatalog getCatalog() {
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    @Property(viewable=true, optional=true, order=4)
    public GenericSchema getSchema() {
        return ((GenericStructContainer)this.getContainer()).getSchema();
    }

    @Nullable
    public synchronized List<? extends GenericTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((GenericStructContainer)this.getContainer()).getTableCache().getChildren(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    public GenericTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (GenericTableColumn)((GenericStructContainer)this.getContainer()).getTableCache().getChild(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this, attributeName);
    }

    public Collection<GenericTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsIndexes()) {
            return ((GenericStructContainer)this.getContainer()).getIndexCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    @Nullable
    public List<GenericUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity() || ((GenericDataSource)this.getDataSource()).getInfo().supportsIndexes()) {
            this.getAttributes(monitor);
            return ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    void addUniqueKey(GenericUniqueKey constraint) {
        ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().cacheObject((DBSObject)constraint);
    }

    public Collection<GenericTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return this.loadReferences(monitor);
        }
        return null;
    }

    public synchronized Collection<GenericTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return ((GenericStructContainer)this.getContainer()).getForeignKeysCache().getObjects(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
        }
        return null;
    }

    @Association
    @Nullable
    public Collection<GenericTableBase> getSubTables() {
        return null;
    }

    @Property(viewable=true, editableExpr="object.dataSource.metaModel.tableCommentEditable", updatableExpr="object.dataSource.metaModel.tableCommentEditable", multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((GenericStructContainer)this.getContainer()).getIndexCache().clearObjectCache((DBSObject)this);
        ((GenericStructContainer)this.getContainer()).getConstraintKeysCache().clearObjectCache((DBSObject)this);
        ((GenericStructContainer)this.getContainer()).getForeignKeysCache().clearObjectCache((DBSObject)this);
        return ((GenericStructContainer)this.getContainer()).getTableCache().refreshObject(monitor, (DBSObject)((GenericStructContainer)this.getContainer()), (DBSObject)this);
    }

    @Property(viewable=false, expensive=true, order=5, category="Statistics")
    @Nullable
    public synchronized Long getRowCount(DBRProgressMonitor monitor) {
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.isView() || !this.isPersisted()) {
            return null;
        }
        if (Boolean.FALSE.equals(((GenericDataSource)this.getDataSource()).getContainer().getDriver().getDriverParameter("supports-select-count"))) {
            return null;
        }
        if (this.rowCount == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                    this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBException e) {
                log.debug((Object)("Can't fetch row count: " + e.getMessage()));
            }
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @Nullable
    public Long getRowCountFromIndexes(DBRProgressMonitor monitor) {
        try {
            Collection<GenericTableIndex> indexList = this.getIndexes(monitor);
            if (!CommonUtils.isEmpty(indexList)) {
                for (GenericTableIndex index : indexList) {
                    long cardinality;
                    if (!index.isUnique() || (cardinality = index.getCardinality()) <= 0L) continue;
                    return cardinality;
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return null;
    }

    public boolean isPhysicalTable() {
        return !this.isView();
    }

    public abstract String getDDL();

    private synchronized List<GenericTableForeignKey> loadReferences(DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted() || !((GenericDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            return new ArrayList<GenericTableForeignKey>();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table relations");){
                GenericMetaObject fkObject = ((GenericDataSource)this.getDataSource()).getMetaObject("foreign-key");
                ArrayList<ForeignKeyInfo> fkInfos = new ArrayList<ForeignKeyInfo>();
                JDBCDatabaseMetaData metaData = session.getMetaData();
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = metaData.getExportedKeys(this.getCatalog() == null ? null : this.getCatalog().getName(), this.getSchema() == null ? null : this.getSchema().getName(), this.getName());){
                    while (dbResult.next()) {
                        ForeignKeyInfo fkInfo = new ForeignKeyInfo();
                        fkInfo.pkColumnName = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "PKCOLUMN_NAME");
                        fkInfo.fkTableCatalog = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "FKTABLE_CAT");
                        fkInfo.fkTableSchema = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "FKTABLE_SCHEM");
                        fkInfo.fkTableName = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "FKTABLE_NAME");
                        fkInfo.fkColumnName = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "FKCOLUMN_NAME");
                        fkInfo.keySeq = GenericUtils.safeGetInt(fkObject, (ResultSet)dbResult, "KEY_SEQ");
                        fkInfo.updateRuleNum = GenericUtils.safeGetInt(fkObject, (ResultSet)dbResult, "UPDATE_RULE");
                        fkInfo.deleteRuleNum = GenericUtils.safeGetInt(fkObject, (ResultSet)dbResult, "DELETE_RULE");
                        fkInfo.fkName = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "FK_NAME");
                        fkInfo.pkName = GenericUtils.safeGetStringTrimmed(fkObject, (ResultSet)dbResult, "PK_NAME");
                        fkInfo.deferabilityNum = GenericUtils.safeGetInt(fkObject, (ResultSet)dbResult, "DEFERRABILITY");
                        fkInfos.add(fkInfo);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                ArrayList<GenericTableForeignKey> fkList = new ArrayList<GenericTableForeignKey>();
                HashMap<String, GenericTableForeignKey> fkMap = new HashMap<String, GenericTableForeignKey>();
                for (ForeignKeyInfo info : fkInfos) {
                    GenericTableForeignKey fk;
                    Collection uniqueKeys;
                    DBSForeignKeyDeferability deferability;
                    DBSForeignKeyModifyRule deleteRule = JDBCUtils.getCascadeFromNum((int)info.deleteRuleNum);
                    DBSForeignKeyModifyRule updateRule = JDBCUtils.getCascadeFromNum((int)info.updateRuleNum);
                    switch (info.deferabilityNum) {
                        case 5: {
                            deferability = DBSForeignKeyDeferability.INITIALLY_DEFERRED;
                            break;
                        }
                        case 6: {
                            deferability = DBSForeignKeyDeferability.INITIALLY_IMMEDIATE;
                            break;
                        }
                        case 7: {
                            deferability = DBSForeignKeyDeferability.NOT_DEFERRABLE;
                            break;
                        }
                        default: {
                            deferability = DBSForeignKeyDeferability.UNKNOWN;
                        }
                    }
                    if (info.fkTableName == null) {
                        log.debug((Object)"Null FK table name");
                        continue;
                    }
                    GenericTableBase fkTable = ((GenericDataSource)this.getDataSource()).findTable(monitor, info.fkTableCatalog, info.fkTableSchema, info.fkTableName);
                    if (fkTable == null) {
                        log.warn((Object)("Can't find FK table " + info.fkTableName));
                        continue;
                    }
                    GenericTableColumn pkColumn = this.getAttribute(monitor, info.pkColumnName);
                    if (pkColumn == null) {
                        log.warn((Object)("Can't find PK column " + info.pkColumnName));
                        continue;
                    }
                    GenericTableColumn fkColumn = fkTable.getAttribute(monitor, info.fkColumnName);
                    if (fkColumn == null) {
                        log.warn((Object)("Can't find FK table " + fkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + info.fkColumnName));
                        continue;
                    }
                    GenericUniqueKey pk = null;
                    if (!CommonUtils.isEmpty((String)info.pkName) && (pk = (GenericUniqueKey)DBUtils.findObject((Collection)this.getConstraints(monitor), (String)info.pkName)) == null) {
                        log.debug((Object)("Unique key '" + info.pkName + "' not found in table " + this.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                    }
                    if (pk == null && (uniqueKeys = this.getConstraints(monitor)) != null) {
                        for (GenericUniqueKey pkConstraint : uniqueKeys) {
                            if (!pkConstraint.getConstraintType().isUnique() || DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)pkConstraint, (DBSEntityAttribute)pkColumn) == null) continue;
                            pk = pkConstraint;
                            break;
                        }
                    }
                    if (pk == null) {
                        log.warn((Object)("Can't find unique key for table " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " column " + pkColumn.getName()));
                        pk = new GenericUniqueKey(this, info.pkName, null, DBSEntityConstraintType.PRIMARY_KEY, true);
                        pk.addColumn(new GenericTableConstraintColumn(pk, pkColumn, info.keySeq));
                        this.addUniqueKey(pk);
                    }
                    if (CommonUtils.isEmpty((String)info.fkName)) {
                        info.fkName = String.valueOf(info.fkTableName.toUpperCase()) + "_FK" + info.keySeq;
                        fk = (GenericTableForeignKey)DBUtils.findObject(fkTable.getAssociations(monitor), (String)info.fkName);
                    } else {
                        fk = (GenericTableForeignKey)DBUtils.findObject(fkTable.getAssociations(monitor), (String)info.fkName);
                        if (fk == null) {
                            log.warn((Object)("Can't find foreign key '" + info.fkName + "' for table " + fkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        }
                    }
                    if (fk != null && !fkList.contains((Object)fk)) {
                        fkList.add(fk);
                    }
                    if (fk != null) continue;
                    fk = (GenericTableForeignKey)((Object)fkMap.get(info.fkName));
                    if (fk == null) {
                        fk = new GenericTableForeignKey(fkTable, info.fkName, null, (DBSEntityReferrer)pk, deleteRule, updateRule, deferability, true);
                        fkMap.put(info.fkName, fk);
                        fkList.add(fk);
                    }
                    GenericTableForeignKeyColumnTable fkColumnInfo = new GenericTableForeignKeyColumnTable(fk, fkColumn, info.keySeq, pkColumn);
                    fk.addColumn(fkColumnInfo);
                }
                return fkList;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            if (ex instanceof SQLFeatureNotSupportedException) {
                log.debug((Object)"Error reading references", (Throwable)ex);
                return Collections.emptyList();
            }
            throw new DBException((Throwable)ex, this.getDataSource());
        }
    }

    @Nullable
    @Association
    public List<? extends GenericTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.triggers == null) {
            this.loadTriggers(monitor);
        }
        return this.triggers;
    }

    private void loadTriggers(DBRProgressMonitor monitor) throws DBException {
        this.triggers = ((GenericDataSource)this.getDataSource()).getMetaModel().loadTriggers(monitor, (GenericStructContainer)this.getContainer(), this);
        if (this.triggers == null) {
            this.triggers = new ArrayList<GenericTrigger>();
        } else {
            DBUtils.orderObjects(this.triggers);
        }
    }

    public List<? extends GenericTrigger> getTriggerCache() {
        return this.triggers;
    }

    private static class ForeignKeyInfo {
        String pkColumnName;
        String fkTableCatalog;
        String fkTableSchema;
        String fkTableName;
        String fkColumnName;
        int keySeq;
        int updateRuleNum;
        int deleteRuleNum;
        String fkName;
        String pkName;
        int deferabilityNum;

        private ForeignKeyInfo() {
        }
    }
}

