/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;

class DataSourceOrigin
implements DBPDataSourceConfigurationStorage {
    private final IFile sourceFile;
    private final boolean isDefault;
    private final String configSuffix;

    DataSourceOrigin(IFile sourceFile, boolean isDefault) {
        this.sourceFile = sourceFile;
        this.isDefault = isDefault;
        if (isDefault) {
            this.configSuffix = "";
        } else {
            String configFileName = sourceFile.getName();
            this.configSuffix = configFileName.substring("data-sources".length(), configFileName.length() - ".json".length());
        }
    }

    public String getStorageId() {
        return "file://" + this.sourceFile.getFullPath().toString();
    }

    public boolean isValid() {
        return true;
    }

    public String getStatus() {
        return "Valid";
    }

    public String getName() {
        return this.sourceFile.getName();
    }

    public String getConfigurationFileSuffix() {
        return this.configSuffix;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public List<? extends DBPDataSourceContainer> loadDataSources(DBPDataSourceRegistry registry, Map<String, Object> options) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public String toString() {
        return this.sourceFile.getFullPath().toString();
    }
}

