/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourcesDescriptor;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class DeleteResourcesProcessor
extends DeleteProcessor {
    private IResource[] fResources;
    private boolean fDeleteContents;

    public DeleteResourcesProcessor(IResource[] resources) {
        this(resources, false);
    }

    public DeleteResourcesProcessor(IResource[] resources, boolean deleteContents) {
        this.fResources = DeleteResourcesProcessor.removeDescendants(resources);
        this.fDeleteContents = deleteContents;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public boolean isDeleteContents() {
        return this.fDeleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.fDeleteContents = deleteContents;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!Resources.containsOnlyProjects(this.fResources) && !Resources.containsOnlyNonProjects(this.fResources)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_mixed_types);
        }
        return new RefactoringStatus();
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            IResource[] iResourceArray = this.fResources;
            int n = this.fResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!this.isSynchronizedExcludingLinkedResources(resource)) {
                    String pathLabel = BasicElementLabels.getPathLabel(resource.getFullPath(), false);
                    String locationLabel = null;
                    IPath location = resource.getLocation();
                    if (location != null) {
                        locationLabel = BasicElementLabels.getPathLabel(location, true);
                    } else {
                        URI uri = resource.getLocationURI();
                        if (uri != null) {
                            locationLabel = BasicElementLabels.getURLPart(uri.toString());
                        }
                    }
                    String warning = resource instanceof IFile ? (locationLabel != null ? Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_file_loc, new Object[]{pathLabel, locationLabel}) : Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_file, pathLabel)) : (locationLabel != null ? Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_container_loc, new Object[]{pathLabel, locationLabel}) : Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_container, pathLabel));
                    result.addWarning(warning);
                }
                ++n2;
            }
            this.checkDirtyResources(result);
            ResourceChangeChecker checker = context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            IResource[] iResourceArray2 = this.fResources;
            int n3 = this.fResources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource fResource = iResourceArray2[n4];
                if (fResource.isPhantom()) {
                    result.addFatalError(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_phantom, BasicElementLabels.getPathLabel(fResource.getFullPath(), false)));
                } else if (this.fDeleteContents && Resources.isReadOnly(fResource)) {
                    result.addFatalError(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_read_only, BasicElementLabels.getPathLabel(fResource.getFullPath(), false)));
                } else {
                    deltaFactory.delete(fResource);
                }
                ++n4;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean isSynchronizedExcludingLinkedResources(IResource resource) throws CoreException {
        final boolean[] result = new boolean[]{true};
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource visitedResource) throws CoreException {
                if (!result[0] || visitedResource.isLinked()) {
                    return false;
                }
                if (!visitedResource.isSynchronized(0)) {
                    result[0] = false;
                    return false;
                }
                return true;
            }
        }, 2, 16);
        return result[0];
    }

    private void checkDirtyResources(final RefactoringStatus result) throws CoreException {
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!(resource instanceof IProject) || ((IProject)resource).isOpen()) {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource visitedResource) throws CoreException {
                        if (visitedResource instanceof IFile) {
                            DeleteResourcesProcessor.this.checkDirtyFile(result, (IFile)visitedResource);
                        }
                        return true;
                    }
                }, 2, false);
            }
            ++n2;
        }
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (!file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            String message = RefactoringCoreMessages.DeleteResourcesProcessor_warning_unsaved_file;
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(Messages.format(message, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            } else {
                result.addFatalError(Messages.format(message, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            }
        }
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.DeleteResourcesProcessor_create_task, this.fResources.length);
        try {
            RefactoringChangeDescriptor descriptor = new RefactoringChangeDescriptor(this.createDescriptor());
            CompositeChange change = new CompositeChange(RefactoringCoreMessages.DeleteResourcesProcessor_change_name);
            change.markAsSynthetic();
            IResource[] iResourceArray = this.fResources;
            int n = this.fResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource fResource = iResourceArray[n2];
                pm.worked(1);
                DeleteResourceChange dc = new DeleteResourceChange(fResource.getFullPath(), true, this.fDeleteContents);
                dc.setDescriptor(descriptor);
                change.add(dc);
                ++n2;
            }
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    protected DeleteResourcesDescriptor createDescriptor() {
        DeleteResourcesDescriptor descriptor = new DeleteResourcesDescriptor();
        descriptor.setProject(null);
        descriptor.setDescription(this.getDeleteDescription());
        descriptor.setComment(descriptor.getDescription());
        descriptor.setFlags(7);
        descriptor.setDeleteContents(this.fDeleteContents);
        descriptor.setResources(this.fResources);
        return descriptor;
    }

    private String getDeleteDescription() {
        if (this.fResources.length == 1) {
            return Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_description_single, BasicElementLabels.getPathLabel(this.fResources[0].getFullPath(), false));
        }
        return Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_description_multi, this.fResources.length);
    }

    @Override
    public Object[] getElements() {
        return this.fResources;
    }

    @Override
    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.deleteResourcesProcessor";
    }

    @Override
    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteResourcesProcessor_processor_name;
    }

    @Override
    public boolean isApplicable() throws CoreException {
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource fResource = iResourceArray[n2];
            if (!this.canDelete(fResource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canDelete(IResource res) {
        return res.isAccessible() && !res.isPhantom();
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<DeleteParticipant> result = new ArrayList<DeleteParticipant>();
        if (!this.isApplicable()) {
            return new RefactoringParticipant[0];
        }
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        DeleteArguments deleteArguments = new DeleteArguments(this.fDeleteContents);
        IResource[] iResourceArray = this.fResources;
        int n = this.fResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource fResource = iResourceArray[n2];
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants(status, this, fResource, deleteArguments, affectedNatures, sharedParticipants)));
            ++n2;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private static IResource[] removeDescendants(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            DeleteResourcesProcessor.addToList(result, resource);
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static void addToList(ArrayList<IResource> result, IResource curr) {
        IPath currPath = curr.getFullPath();
        int k = result.size() - 1;
        while (k >= 0) {
            IResource other = result.get(k);
            IPath otherPath = other.getFullPath();
            if (otherPath.isPrefixOf(currPath)) {
                return;
            }
            if (currPath.isPrefixOf(otherPath)) {
                result.remove(k);
            }
            --k;
        }
        result.add(curr);
    }

    public RefactoringStatus setResources(IResource[] resources, IProgressMonitor pm) throws OperationCanceledException, CoreException {
        this.fResources = resources;
        return this.checkInitialConditions(pm);
    }
}

