/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DiagramObjectCollector {
    private static final Log log = Log.getLog(DiagramObjectCollector.class);
    private final EntityDiagram diagram;
    private final List<ERDEntity> erdEntities = new ArrayList<ERDEntity>();
    private boolean showViews;
    private boolean showPartitions;

    public DiagramObjectCollector(EntityDiagram diagram) {
        this.diagram = diagram;
    }

    public static Collection<DBSEntity> collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, boolean forceShowViews) throws DBException {
        LinkedHashSet<DBSEntity> tables = new LinkedHashSet<DBSEntity>();
        DiagramObjectCollector.collectTables(monitor, roots, tables, forceShowViews);
        return tables;
    }

    public void setShowViews(boolean showViews) {
        this.showViews = showViews;
    }

    /*
     * WARNING - void declaration
     */
    private static void collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, Set<DBSEntity> tables, boolean forceShowViews) throws DBException {
        boolean showPartitions = ERDActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.partitions");
        boolean showViews = ERDActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.views");
        for (DBSObject dBSObject : roots) {
            void var6_7;
            if (monitor.isCanceled()) break;
            DBSObject dBSObject2 = DBUtils.getPublicObject((DBSObject)dBSObject);
            if (dBSObject2 instanceof DBSAlias) {
                DBSObject dBSObject3 = ((DBSAlias)dBSObject2).getTargetObject(monitor);
            }
            if (var6_7 instanceof DBSFolder) {
                DiagramObjectCollector.collectTables(monitor, ((DBSFolder)var6_7).getChildrenObjects(monitor), tables, false);
            } else if (var6_7 instanceof DBSEntity) {
                if (var6_7 instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)((DBSEntity)var6_7)) && !showViews && !forceShowViews) continue;
                tables.add((DBSEntity)var6_7);
            }
            if (!(var6_7 instanceof DBSObjectContainer)) continue;
            DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)var6_7, tables, showViews, showPartitions);
        }
    }

    private static void collectTables(DBRProgressMonitor monitor, DBSObjectContainer container, Set<DBSEntity> tables, boolean showViews, boolean showPartitions) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        container.cacheStructure(monitor, 7);
        Collection children = container.getChildren(monitor);
        if (!CommonUtils.isEmpty((Collection)children)) {
            Class childType = container.getPrimaryChildType(monitor);
            DBSObjectFilter objectFilter = container.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)container, true);
            for (DBSObject entity : children) {
                if (monitor.isCanceled()) break;
                if (objectFilter != null && !objectFilter.matches(entity.getName())) continue;
                if (entity instanceof DBSEntity) {
                    if (entity instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)((DBSEntity)entity)) && !showViews) continue;
                    tables.add((DBSEntity)entity);
                    continue;
                }
                if (!(entity instanceof DBSObjectContainer)) continue;
                DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)entity, tables, showViews, showPartitions);
            }
        }
    }

    public void generateDiagramObjects(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots) throws DBException {
        Collection<DBSEntity> tables = DiagramObjectCollector.collectTables(monitor, roots, this.showViews);
        for (DBSEntity table : tables) {
            if (DBUtils.isHiddenObject((Object)table)) continue;
            this.addDiagramEntity(monitor, table);
        }
        for (ERDEntity erdEntity : this.erdEntities) {
            erdEntity.addModelRelations(monitor, this.diagram, true, false);
        }
    }

    private void addDiagramEntity(DBRProgressMonitor monitor, DBSEntity table) {
        if (this.diagram.containsTable(table) && !this.diagram.getDecorator().allowEntityDuplicates()) {
            return;
        }
        ERDEntity erdEntity = ERDUtils.makeEntityFromObject(monitor, this.diagram, this.erdEntities, table, null);
        if (erdEntity != null) {
            this.erdEntities.add(erdEntity);
        }
    }

    private boolean aliasExist(String alias) {
        for (ERDEntity entity : this.erdEntities) {
            if (!CommonUtils.equalObjects((Object)entity.getAlias(), (Object)alias)) continue;
            return true;
        }
        return false;
    }

    public List<ERDEntity> getDiagramEntities() {
        return this.erdEntities;
    }

    public static List<ERDEntity> generateEntityList(EntityDiagram diagram, Collection<DBPNamedObject> objects, boolean forceShowViews) {
        ArrayList<DBSObject> roots = new ArrayList<DBSObject>();
        for (DBPNamedObject object : objects) {
            if (!(object instanceof DBSObject)) continue;
            roots.add((DBSObject)object);
        }
        ArrayList<ERDEntity> entities = new ArrayList<ERDEntity>();
        try {
            UIUtils.runInProgressService(monitor -> {
                DiagramObjectCollector collector = new DiagramObjectCollector(diagram);
                collector.setShowViews(forceShowViews);
                try {
                    collector.generateDiagramObjects(monitor, roots);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                entities.addAll(collector.getDiagramEntities());
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return entities;
    }
}

