/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.util.Map;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.ParserVisitor;

public class ASTJexlScript
extends JexlNode {
    private Scope scope = null;
    Map<String, Object> pragmas = null;

    public ASTJexlScript(int id) {
        super(id);
    }

    public ASTJexlScript(Parser p, int id) {
        super(p, id);
    }

    public ASTJexlScript script() {
        if (this.scope == null && this.jjtGetNumChildren() == 1 && this.jjtGetChild(0) instanceof ASTJexlLambda) {
            ASTJexlLambda lambda = (ASTJexlLambda)this.jjtGetChild(0);
            lambda.jjtSetParent(null);
            return lambda;
        }
        return this;
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean toExpression() {
        if (this.jjtGetNumChildren() > 1) {
            this.jjtSetChildren(new JexlNode[]{this.jjtGetChild(0)});
            return true;
        }
        return false;
    }

    public void setScope(Scope theScope) {
        this.scope = theScope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, Object> getPragmas() {
        return this.pragmas;
    }

    public Scope.Frame createFrame(Object ... values) {
        Scope.Frame frame;
        if (this.scope != null && (frame = this.scope.createFrame(null)) != null) {
            return frame.assign(values);
        }
        return null;
    }

    public int getArgCount() {
        return this.scope != null ? this.scope.getArgCount() : 0;
    }

    public String[] getSymbols() {
        return this.scope != null ? this.scope.getSymbols() : null;
    }

    public String[] getParameters() {
        return this.scope != null ? this.scope.getParameters() : null;
    }

    public String[] getLocalVariables() {
        return this.scope != null ? this.scope.getLocalVariables() : null;
    }

    public boolean isHoistedSymbol(int symbol) {
        return this.scope != null ? this.scope.isHoistedSymbol(symbol) : false;
    }
}

