/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndexColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public class MySQLIndexManager
extends SQLIndexManager<MySQLTableIndex, MySQLTable>
implements DBEObjectRenamer<MySQLTableIndex> {
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableIndex> getObjectsCache(MySQLTableIndex object) {
        return ((MySQLCatalog)((MySQLTable)object.getTable()).getContainer()).getIndexCache();
    }

    protected MySQLTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        return new MySQLTableIndex((MySQLTable)container, false, null, DBSIndexType.OTHER, null, false);
    }

    protected String getDropIndexPattern(MySQLTableIndex index) {
        return "ALTER TABLE %TABLE% DROP INDEX %INDEX_SHORT%";
    }

    protected void appendIndexType(MySQLTableIndex index, StringBuilder decl) {
        DBSIndexType indexType = index.getIndexType();
        if (indexType != MySQLConstants.INDEX_TYPE_FULLTEXT) {
            decl.append(" USING ").append(indexType.getId());
        }
    }

    protected void appendIndexModifiers(MySQLTableIndex index, StringBuilder decl) {
        if (index.getIndexType() == MySQLConstants.INDEX_TYPE_FULLTEXT) {
            decl.append(" FULLTEXT");
        } else {
            super.appendIndexModifiers((JDBCTableIndex)index, decl);
        }
    }

    protected void appendIndexColumnModifiers(DBRProgressMonitor monitor, StringBuilder decl, DBSTableIndexColumn indexColumn) {
        String subPart = ((MySQLTableIndexColumn)indexColumn).getSubPart();
        if (!CommonUtils.isEmpty((String)subPart)) {
            decl.append(" (").append(subPart).append(")");
        }
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    public void renameObject(DBECommandContext commandContext, MySQLTableIndex object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        MySQLDataSource dataSource = ((MySQLTableIndex)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + ((MySQLTable)((MySQLTableIndex)command.getObject()).getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + "\nRENAME INDEX " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }
}

