/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;

public class DatabaseNodeEditorInput
extends DatabaseEditorInput<DBNDatabaseNode> {
    public DatabaseNodeEditorInput(@NotNull DBNDatabaseNode dbmNode) {
        super(dbmNode);
    }

    public DatabaseNodeEditorInput(@NotNull DBNDatabaseNode dbnDatabaseNode, @Nullable DBECommandContext commandContext) {
        super(dbnDatabaseNode, commandContext);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSObject.class) {
            DBSObject databaseObject = this.getDatabaseObject();
            return adapter.cast(databaseObject);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getToolTipText() {
        StringBuilder toolTip = new StringBuilder();
        Object node = this.getNavigatorNode();
        while (node != null) {
            if (!(node instanceof DBSFolder)) {
                toolTip.append(node.getNodeType());
                toolTip.append(": ");
                toolTip.append(node.getNodeName());
                toolTip.append(" \n");
                if (node instanceof DBNDataSource) break;
            }
            node = node.getParentNode();
        }
        return toolTip.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DatabaseNodeEditorInput && super.equals(obj);
    }
}

