/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectContainerSelectorPanel
extends Composite {
    private static final Log log = Log.getLog(ObjectContainerSelectorPanel.class);
    public static final int MAX_HISTORY_LENGTH = 20;
    private final DBPProject project;
    private final String selectorId;
    private final Label containerIcon;
    private final Combo containerNameCombo;
    private final List<HistoryItem> historyItems = new ArrayList<HistoryItem>();

    protected ObjectContainerSelectorPanel(Composite parent, DBPProject project, String selectorId, String containerTitle, String containerHint) {
        super(parent, 0);
        this.project = project;
        this.selectorId = selectorId;
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        UIUtils.createControlLabel(this, containerTitle);
        this.containerIcon = new Label((Composite)this, 0);
        this.containerIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_UNKNOWN));
        this.containerNameCombo = new Combo((Composite)this, 2060);
        this.containerNameCombo.setLayoutData((Object)new GridData(768));
        this.containerNameCombo.setText("");
        if (containerHint != null) {
            UIUtils.addEmptyTextHint(this.containerNameCombo, text -> containerHint);
        }
        this.containerNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectContainerSelectorPanel.this.handleContainerChange();
            }
        });
        Button browseButton = new Button((Composite)this, 8);
        browseButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        browseButton.setText("...");
        final Runnable containerSelector = () -> {
            if (project != null) {
                DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
                DBNProject rootNode = navigatorModel.getRoot().getProjectNode(project);
                DBNNode selectedNode = this.getSelectedNode();
                DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.getShell(), containerHint != null ? containerHint : containerTitle, (DBNNode)rootNode.getDatabases(), selectedNode, new Class[]{DBSObjectContainer.class}, new Class[]{DBSObjectContainer.class}, new Class[]{DBSSchema.class});
                try {
                    this.checkValidContainerNode(node);
                    this.setSelectedNode((DBNDatabaseNode)node);
                    this.addNodeToHistory((DBNDatabaseNode)node);
                    this.saveHistory();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Bad container node", "Node '" + node.getName() + "' cannot be selected as table container", (Throwable)e);
                }
            }
        };
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                containerSelector.run();
            }
        });
        this.containerNameCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                containerSelector.run();
            }
        });
        this.loadHistory();
    }

    public void checkValidContainerNode(DBNNode node) throws DBException {
        block7: {
            if (node instanceof DBNDatabaseNode) {
                DBSObject nodeObject = DBUtils.getPublicObject((DBSObject)((DBNDatabaseNode)node).getObject());
                if (nodeObject instanceof DBSObjectContainer) {
                    try {
                        Class childrenClass = ((DBSObjectContainer)nodeObject).getChildType((DBRProgressMonitor)new VoidProgressMonitor());
                        if (childrenClass != null) {
                            if (!DBSEntity.class.isAssignableFrom(childrenClass)) {
                                throw new DBException("You can select only table container (e.g. schema).");
                            }
                            break block7;
                        }
                        throw new DBException("Can't determine container child objects for " + nodeObject);
                    }
                    catch (DBException e) {
                        throw new DBException("Error determining container elements type", (Throwable)e);
                    }
                }
            } else {
                throw new DBException("Non-databse node " + node);
            }
        }
    }

    private HistoryItem addNodeToHistory(DBNDatabaseNode node) {
        int i = 0;
        while (i < this.historyItems.size()) {
            HistoryItem item = this.historyItems.get(i);
            if (item.containerPath.equals(node.getNodeItemPath())) {
                item.containerNode = node;
                this.moveHistoryItemToBeginning(item);
                return item;
            }
            ++i;
        }
        HistoryItem newItem = new HistoryItem(node.getNodeFullName(), node.getNodeItemPath(), node.getDataSourceContainer().getName(), node);
        this.historyItems.add(0, newItem);
        return newItem;
    }

    private void moveHistoryItemToBeginning(HistoryItem item) {
        this.historyItems.remove(item);
        this.historyItems.add(0, item);
        this.removeItemFromCombo(item);
        this.containerNameCombo.add(item.getFullName(), 0);
        this.containerNameCombo.select(0);
    }

    private void handleContainerChange() {
        int historyIndex = this.containerNameCombo.getSelectionIndex();
        if (historyIndex >= 0 && historyIndex < this.historyItems.size()) {
            HistoryItem historyItem = this.historyItems.get(historyIndex);
            if (historyItem.containerNode == null) {
                try {
                    UIUtils.runInProgressDialog(monitor -> {
                        try {
                            DBNNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath(monitor, this.project, historyItem.containerPath);
                            if (node instanceof DBNDatabaseNode) {
                                historyItem.containerNode = (DBNDatabaseNode)node;
                            }
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Bad container path", "Can't find database node by path " + historyItem.containerPath, e.getTargetException());
                }
            }
            if (historyItem.containerNode != null) {
                this.setSelectedNode(historyItem.containerNode);
                this.moveHistoryItemToBeginning(historyItem);
            } else {
                this.historyItems.remove(historyIndex);
                this.containerNameCombo.remove(historyIndex);
            }
        }
    }

    private void loadHistory() {
        IDialogSettings selectorSection;
        IDialogSettings historySection = UIUtils.getDialogSettings("ObjectContainerSelector");
        IDialogSettings projectSection = historySection.getSection(this.project.getName());
        if (projectSection != null && (selectorSection = projectSection.getSection(this.selectorId)) != null) {
            int i = 1;
            while (i < 20) {
                IDialogSettings itemSection = selectorSection.getSection("item" + i);
                if (itemSection == null) break;
                this.historyItems.add(new HistoryItem(itemSection.get("name"), itemSection.get("path"), itemSection.get("data-source"), null));
                ++i;
            }
        }
        for (HistoryItem item : this.historyItems) {
            this.containerNameCombo.add(item.getFullName());
        }
    }

    private void saveHistory() {
        IDialogSettings selectorHistorySection = UIUtils.getDialogSettings("ObjectContainerSelector");
        IDialogSettings projectSection = UIUtils.getSettingsSection(selectorHistorySection, this.project.getName());
        IDialogSettings selectorSection = projectSection.addNewSection(this.selectorId);
        int i = 0;
        while (i < this.historyItems.size()) {
            HistoryItem item = this.historyItems.get(i);
            IDialogSettings itemSection = selectorSection.addNewSection("item" + (i + 1));
            itemSection.put("name", item.containerName);
            itemSection.put("path", item.containerPath);
            itemSection.put("data-source", item.dataSourceName);
            ++i;
        }
    }

    public void setContainerInfo(DBNDatabaseNode node) {
        if (node == null) {
            this.containerIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_UNKNOWN));
            this.containerNameCombo.select(-1);
            return;
        }
        HistoryItem item = this.addNodeToHistory(node);
        this.containerIcon.setImage(DBeaverIcons.getImage(node.getNodeIconDefault()));
        this.removeItemFromCombo(item);
        this.containerNameCombo.add(item.getFullName(), 0);
        this.containerNameCombo.select(0);
    }

    private void removeItemFromCombo(HistoryItem item) {
        int itemCount = this.containerNameCombo.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.containerNameCombo.getItem(i).equals(item.getFullName())) {
                this.containerNameCombo.remove(i);
                break;
            }
            ++i;
        }
    }

    protected abstract void setSelectedNode(DBNDatabaseNode var1);

    @Nullable
    protected abstract DBNNode getSelectedNode();

    private static class HistoryItem {
        private String containerName;
        private String containerPath;
        private String dataSourceName;
        private DBNDatabaseNode containerNode;

        HistoryItem(String containerName, String containerPath, String dataSourceName, DBNDatabaseNode node) {
            this.containerName = containerName;
            this.containerPath = containerPath;
            this.dataSourceName = dataSourceName;
            this.containerNode = node;
        }

        public String getFullName() {
            String dsName;
            String string = dsName = this.containerNode != null ? this.containerNode.getDataSourceContainer().getName() : this.dataSourceName;
            if (CommonUtils.equalObjects((Object)dsName, (Object)this.containerName)) {
                return this.containerName;
            }
            return String.valueOf(this.containerName) + "  [" + dsName + "]";
        }
    }
}

