/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentValueHandler;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterSQL
extends StreamExporterAbstract {
    private static final Log log = Log.getLog(DataExporterSQL.class);
    private static final String PROP_INCLUDE_AUTO_GENERATED = "includeAutoGenerated";
    private static final String PROP_OMIT_SCHEMA = "omitSchema";
    private static final String PROP_ROWS_IN_STATEMENT = "rowsInStatement";
    private static final char STRING_QUOTE = '\'';
    private boolean includeAutoGenerated;
    private String rowDelimiter;
    private boolean omitSchema;
    private int rowsInStatement;
    private String tableName;
    private DBDAttributeBinding[] columns;
    private transient StringBuilder sqlBuffer = new StringBuilder(100);
    private transient long rowCount;
    private SQLDialect dialect;

    private boolean isSkipColumn(DBDAttributeBinding attr) {
        return attr.isPseudoAttribute() || !this.includeAutoGenerated && attr.isAutoGenerated();
    }

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        if (site.getProperties().containsKey(PROP_INCLUDE_AUTO_GENERATED)) {
            this.includeAutoGenerated = CommonUtils.toBoolean((Object)site.getProperties().get(PROP_INCLUDE_AUTO_GENERATED));
        }
        if (site.getProperties().containsKey(PROP_OMIT_SCHEMA)) {
            this.omitSchema = CommonUtils.toBoolean((Object)site.getProperties().get(PROP_OMIT_SCHEMA));
        }
        try {
            this.rowsInStatement = Integer.parseInt(String.valueOf(site.getProperties().get(PROP_ROWS_IN_STATEMENT)));
        }
        catch (NumberFormatException numberFormatException) {
            this.rowsInStatement = 10;
        }
        this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        this.dialect = SQLUtils.getDialectFromObject((DBPObject)site.getSource());
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        DBPNamedObject source = this.getSite().getSource();
        this.tableName = DTUtils.getTableName(session.getDataSource(), source, this.omitSchema);
        this.rowCount = 0L;
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        DBDAttributeBinding column;
        int i;
        SQLDialect.MultiValueInsertMode insertMode;
        PrintWriter out = this.getWriter();
        SQLDialect.MultiValueInsertMode multiValueInsertMode = insertMode = this.rowsInStatement == 1 ? SQLDialect.MultiValueInsertMode.NOT_SUPPORTED : this.getMultiValueInsertMode();
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED) {
            this.rowsInStatement = 1;
        }
        int columnsSize = this.columns.length;
        boolean firstRow = false;
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED || this.rowCount % (long)this.rowsInStatement == 0L) {
            this.sqlBuffer.setLength(0);
            if (this.rowCount > 0L) {
                if (insertMode == SQLDialect.MultiValueInsertMode.PLAIN) {
                    this.sqlBuffer.append(");").append(this.rowDelimiter);
                } else if (insertMode == SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
                    this.sqlBuffer.append(";").append(this.rowDelimiter);
                }
            }
            this.sqlBuffer.append("INSERT INTO ").append(this.tableName).append(" (");
            boolean hasColumn = false;
            i = 0;
            while (i < columnsSize) {
                column = this.columns[i];
                if (!this.isSkipColumn(column)) {
                    if (hasColumn) {
                        this.sqlBuffer.append(',');
                    }
                    hasColumn = true;
                    this.sqlBuffer.append(DBUtils.getQuotedIdentifier((DBSObject)column));
                }
                ++i;
            }
            this.sqlBuffer.append(") VALUES ");
            if (insertMode != SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
                this.sqlBuffer.append("(");
            }
            if (this.rowsInStatement > 1) {
                this.sqlBuffer.append(this.rowDelimiter);
            }
            out.write(this.sqlBuffer.toString());
            firstRow = true;
        }
        if (insertMode != SQLDialect.MultiValueInsertMode.NOT_SUPPORTED && !firstRow) {
            out.write(",");
        }
        if (insertMode == SQLDialect.MultiValueInsertMode.GROUP_ROWS) {
            out.write("(");
        }
        ++this.rowCount;
        boolean hasValue = false;
        i = 0;
        while (i < columnsSize) {
            block40: {
                column = this.columns[i];
                if (!this.isSkipColumn(column)) {
                    if (hasValue) {
                        out.write(44);
                    }
                    hasValue = true;
                    Object value = row[i];
                    if (DBUtils.isNullValue((Object)value)) {
                        out.write("NULL");
                    } else if (row[i] instanceof DBDContent) {
                        DBDContent content;
                        block39: {
                            content = (DBDContent)row[i];
                            try {
                                try {
                                    if (column.getValueHandler() instanceof DBDContentValueHandler) {
                                        ((DBDContentValueHandler)column.getValueHandler()).writeStreamValue(session.getProgressMonitor(), session.getDataSource(), (DBSTypedObject)column, content, (Writer)out);
                                        break block39;
                                    }
                                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                                    if (cs == null) break block39;
                                    if (ContentUtils.isTextContent((DBDContent)content)) {
                                        Throwable throwable = null;
                                        Object var15_17 = null;
                                        try (Reader contentReader = cs.getContentReader();){
                                            this.writeStringValue(contentReader);
                                            break block39;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    this.getSite().writeBinaryData(cs);
                                }
                                catch (Exception e) {
                                    log.warn((Object)e);
                                    content.release();
                                    break block40;
                                }
                            }
                            catch (Throwable throwable) {
                                content.release();
                                throw throwable;
                            }
                        }
                        content.release();
                    } else if (value instanceof File) {
                        out.write("@");
                        out.write(((File)value).getAbsolutePath());
                    } else {
                        out.write(SQLUtils.convertValueToSQL((DBPDataSource)session.getDataSource(), (DBSAttributeBase)column, (Object)row[i]));
                    }
                }
            }
            ++i;
        }
        if (insertMode != SQLDialect.MultiValueInsertMode.PLAIN) {
            out.write(")");
        }
        if (insertMode == SQLDialect.MultiValueInsertMode.NOT_SUPPORTED) {
            out.write(";");
        }
        out.write(this.rowDelimiter);
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        switch (this.getMultiValueInsertMode()) {
            case GROUP_ROWS: {
                if (this.rowCount <= 0L) break;
                this.getWriter().write(";");
                break;
            }
            case PLAIN: {
                if (this.rowCount <= 0L) break;
                this.getWriter().write(");");
                break;
            }
        }
    }

    private void writeStringValue(String value) {
        PrintWriter out = this.getWriter();
        out.write(39);
        if (this.dialect != null) {
            out.write(this.dialect.escapeString(value));
        } else {
            out.write(value);
        }
        out.write(39);
    }

    private void writeStringValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            out.write(39);
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                if (this.dialect != null) {
                    out.write(this.dialect.escapeString(String.valueOf(buffer, 0, count)));
                    continue;
                }
                out.write(buffer, 0, count);
            }
            out.write(39);
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        SQLDialect.MultiValueInsertMode insertMode = SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
        if (this.dialect != null) {
            insertMode = this.dialect.getMultiValueInsertMode();
        }
        return insertMode;
    }
}

