/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ExasolConsumerGroupDialog
extends BaseDialog {
    private String name = "";
    private BigDecimal cpuWeight = null;
    private BigDecimal userRamLimit = null;
    private BigDecimal groupRamLimit = null;
    private BigDecimal sessionRamLimit = null;
    private BigDecimal precedence = null;
    private String comment = "";
    private ExasolConsumerGroup group;

    public ExasolConsumerGroupDialog(Shell parentShell, ExasolConsumerGroup group) {
        super(parentShell, ExasolMessages.dialog_create_consumer_group, null);
        this.group = group;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 250;
        gd.verticalIndent = 0;
        gd.horizontalIndent = 0;
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayout((Layout)new GridLayout(2, false));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_name, (String)"");
        final Text cpuWeightText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_cpu_weight, (String)"");
        Text precedenceText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_precedence, (String)"");
        Text userRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_user_limit, (String)"");
        Text groupRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_group_limit, (String)"");
        Text sessionRamLimitText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_consumer_group_session_limit, (String)"");
        cpuWeightText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        userRamLimitText.addVerifyListener(UIUtils.getLongVerifyListener((Text)userRamLimitText));
        groupRamLimitText.addVerifyListener(UIUtils.getLongVerifyListener((Text)groupRamLimitText));
        sessionRamLimitText.addVerifyListener(UIUtils.getLongVerifyListener((Text)sessionRamLimitText));
        precedenceText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        final HashMap<Text, BigDecimal> limits = new HashMap<Text, BigDecimal>();
        limits.put(cpuWeightText, this.cpuWeight);
        limits.put(sessionRamLimitText, this.sessionRamLimit);
        limits.put(groupRamLimitText, this.groupRamLimit);
        limits.put(userRamLimitText, this.userRamLimit);
        limits.put(precedenceText, this.precedence);
        final Text commentText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_priority_group_description, (String)"");
        ModifyListener mod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExasolConsumerGroupDialog.this.name = nameText.getText();
                try {
                    ExasolConsumerGroupDialog.this.cpuWeight = new BigDecimal(cpuWeightText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                ExasolConsumerGroupDialog.this.comment = commentText.getText();
                for (Map.Entry entry : limits.entrySet()) {
                    String text = ((Text)entry.getKey()).getText();
                    BigDecimal cfr_ignored_0 = (BigDecimal)entry.getValue();
                    if ("".compareTo(text) == 0) continue;
                    try {
                        new BigDecimal(text);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (ExasolConsumerGroupDialog.this.name.isEmpty() | ExasolConsumerGroupDialog.this.cpuWeight == null) {
                    ExasolConsumerGroupDialog.this.getButton(0).setEnabled(false);
                } else {
                    ExasolConsumerGroupDialog.this.getButton(0).setEnabled(true);
                }
            }
        };
        nameText.addModifyListener(mod);
        commentText.addModifyListener(mod);
        cpuWeightText.addModifyListener(mod);
        return composite;
    }

    public ExasolConsumerGroup getConsumerGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public int getCpuWeight() {
        return this.cpuWeight.intValue();
    }

    public String getComment() {
        return this.comment;
    }

    public BigDecimal getUserRamLimit() {
        return this.userRamLimit;
    }

    public BigDecimal getGroupRamLimit() {
        return this.groupRamLimit;
    }

    public BigDecimal getSessionRamLimit() {
        return this.sessionRamLimit;
    }

    public Integer getPrecedence() {
        return this.precedence.intValue();
    }

    protected void okPressed() {
        super.okPressed();
        this.group.setCpuWeight(this.getCpuWeight());
        this.group.setDescription(this.getComment());
        this.group.setGroupRamLimit(this.getGroupRamLimit());
        this.group.setName(this.getName());
        this.group.setPrecedence(this.getPrecedence());
        this.group.setSessionRamLimit(this.getSessionRamLimit());
        this.group.setUserRamLimit(this.getUserRamLimit());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

