/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.sql.task.SQLToolRunListener;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatistics;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizardPageSettings;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizardPageStatus;
import org.jkiss.dbeaver.tasks.ui.sql.internal.TasksSQLUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskWizardExecutor;
import org.jkiss.dbeaver.ui.UIUtils;

class SQLToolTaskWizard
extends TaskConfigurationWizard<SQLToolExecuteSettings> {
    private static final Log log = Log.getLog(SQLToolTaskWizard.class);
    private SQLToolExecuteSettings settings;
    private SQLToolTaskWizardPageSettings pageSettings;
    private SQLToolTaskWizardPageStatus pageStatus;
    private SQLToolExecuteHandler taskHandler;

    public SQLToolTaskWizard() {
    }

    public SQLToolTaskWizard(@NotNull DBTTask task) {
        super(task);
        try {
            this.taskHandler = (SQLToolExecuteHandler)task.getType().createHandler();
        }
        catch (DBException e) {
            throw new IllegalArgumentException("Error instantiating task type handler", e);
        }
        this.settings = this.taskHandler.createToolSettings();
        this.settings.loadConfiguration(UIUtils.getDialogRunnableContext(), task.getProperties());
    }

    public SQLToolExecuteHandler getTaskHandler() {
        return this.taskHandler;
    }

    protected String getDefaultWindowTitle() {
        return this.getTaskType().getName();
    }

    public String getTaskTypeId() {
        return this.getCurrentTask().getType().getId();
    }

    public void addPages() {
        super.addPages();
        this.pageSettings = new SQLToolTaskWizardPageSettings(this);
        this.pageStatus = new SQLToolTaskWizardPageStatus(this);
        this.addPage((IWizardPage)this.pageSettings);
        this.addPage((IWizardPage)this.pageStatus);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageSettings) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        this.pageSettings.saveSettings();
        this.settings.saveConfiguration(state);
    }

    public SQLToolExecuteSettings getSettings() {
        return this.settings;
    }

    public boolean performFinish() {
        if (this.isRunTaskOnFinish()) {
            this.saveConfigurationToTask(this.getCurrentTask());
            return super.performFinish();
        }
        try {
            DBTTask task = this.getCurrentTask();
            this.saveConfigurationToTask(task);
            this.pageStatus.clearLog();
            this.getContainer().showPage((IWizardPage)this.pageStatus);
            SQLTaskExecutor executor = new SQLTaskExecutor(task);
            executor.executeTask();
            return false;
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(e.getMessage(), TasksSQLUIMessages.sql_tool_task_wizard_message_error_running_task, (Throwable)e);
            return false;
        }
    }

    private class SQLTaskExecutor
    extends TaskWizardExecutor
    implements SQLToolRunListener {
        SQLTaskExecutor(DBTTask task) {
            super(SQLToolTaskWizard.this.getRunnableContext(), task, log, SQLToolTaskWizard.this.pageStatus.getLogWriter());
        }

        public void handleActionStatistics(DBPObject object, DBEPersistAction action, DBCSession session, List<? extends SQLToolStatistics> statistics) {
            SQLToolTaskWizard.this.pageStatus.addStatistics(object, statistics);
        }
    }
}

