/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolTableTruncateSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;

public class PostgreToolTableTruncate
extends PostgreToolWithStatus<PostgreTableBase, PostgreToolTableTruncateSettings> {
    private static final Log log = Log.getLog(PostgreToolTableTruncate.class);

    @NotNull
    public PostgreToolTableTruncateSettings createToolSettings() {
        return new PostgreToolTableTruncateSettings();
    }

    public void generateObjectQueries(DBCSession session, PostgreToolTableTruncateSettings settings, List<DBEPersistAction> queries, PostgreTableBase object) throws DBCException {
        if (settings.isRunning()) {
            this.commitChanges(session);
        }
        String sql = "TRUNCATE TABLE";
        if (settings.isOnly()) {
            sql = String.valueOf(sql) + " ONLY";
        }
        sql = String.valueOf(sql) + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        sql = settings.isRestarting() ? String.valueOf(sql) + " RESTART IDENTITY" : String.valueOf(sql) + " CONTINUE IDENTITY";
        sql = settings.isCascading() ? String.valueOf(sql) + " CASCADE" : String.valueOf(sql) + " RESTRICT";
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
    }

    private void commitChanges(DBCSession session) {
        try {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && !txnManager.isAutoCommit()) {
                txnManager.commit(session);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error committing transactions", e);
        }
    }
}

