/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTriggerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSActionTiming;
import org.jkiss.dbeaver.model.struct.DBSEntityElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.utils.CommonUtils;

public class PostgreTrigger
implements DBSTrigger,
DBSEntityElement,
DBPQualifiedObject,
PostgreObject,
PostgreScriptObject,
DBPStatefulObject {
    private static final Log log = Log.getLog(PostgreTrigger.class);
    public static final int TRIGGER_TYPE_ROW = 1;
    public static final int TRIGGER_TYPE_BEFORE = 2;
    public static final int TRIGGER_TYPE_INSERT = 4;
    public static final int TRIGGER_TYPE_DELETE = 8;
    public static final int TRIGGER_TYPE_UPDATE = 16;
    public static final int TRIGGER_TYPE_TRUNCATE = 32;
    public static final int TRIGGER_TYPE_INSTEAD = 64;
    private PostgreTableReal table;
    private long objectId;
    private String enabledState;
    private String whenExpression;
    private long functionSchemaId;
    private long functionId;
    private String body;
    protected String name;
    private DBSActionTiming actionTiming;
    private DBSManipulationType[] manipulationTypes;
    private PostgreTriggerType type;
    private boolean persisted;
    private PostgreTableColumn[] columnRefs;
    protected String description;

    public PostgreTrigger(DBRProgressMonitor monitor, PostgreTableReal table, ResultSet dbResult) throws DBException {
        int[] attrNumbers;
        this.persisted = true;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tgname");
        this.table = table;
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.enabledState = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tgenabled");
        this.whenExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tgqual");
        this.functionSchemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"func_schema_id");
        this.functionId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"tgfoid");
        int tgType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"tgtype");
        this.actionTiming = CommonUtils.isBitSet((int)tgType, (int)2) ? DBSActionTiming.BEFORE : (CommonUtils.isBitSet((int)tgType, (int)64) ? DBSActionTiming.INSTEAD : DBSActionTiming.AFTER);
        ArrayList<DBSManipulationType> mt = new ArrayList<DBSManipulationType>(1);
        if (CommonUtils.isBitSet((int)tgType, (int)4)) {
            mt.add(DBSManipulationType.INSERT);
        }
        if (CommonUtils.isBitSet((int)tgType, (int)8)) {
            mt.add(DBSManipulationType.DELETE);
        }
        if (CommonUtils.isBitSet((int)tgType, (int)16)) {
            mt.add(DBSManipulationType.UPDATE);
        }
        if (CommonUtils.isBitSet((int)tgType, (int)32)) {
            mt.add(DBSManipulationType.TRUNCATE);
        }
        this.manipulationTypes = mt.toArray(new DBSManipulationType[0]);
        this.type = CommonUtils.isBitSet((int)tgType, (int)1) ? PostgreTriggerType.ROW : PostgreTriggerType.STATEMENT;
        Object attrNumbersObject = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"tgattr");
        if (attrNumbersObject != null && (attrNumbers = PostgreUtils.getIntVector(attrNumbersObject)) != null) {
            int attrCount = attrNumbers.length;
            this.columnRefs = new PostgreTableColumn[attrCount];
            int i = 0;
            while (i < attrCount) {
                int colNumber = attrNumbers[i];
                PostgreTableColumn attr = (PostgreTableColumn)PostgreUtils.getAttributeByNum(this.getTable().getAttributes(monitor), colNumber);
                if (attr == null) {
                    log.warn((Object)("Bad trigger attribute ref index: " + colNumber));
                } else {
                    this.columnRefs[i] = attr;
                }
                ++i;
            }
        }
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    public PostgreTrigger(DBRProgressMonitor monitor, PostgreTableReal parent) {
        this.table = parent;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBody() {
        return this.body;
    }

    @Property(viewable=true, order=2)
    public DBSActionTiming getActionTiming() {
        return this.actionTiming;
    }

    @Property(viewable=true, order=3)
    public DBSManipulationType[] getManipulationTypes() {
        return this.manipulationTypes;
    }

    @Property(viewable=true, order=4)
    public PostgreTriggerType getType() {
        return this.type;
    }

    @Property(viewable=true, order=5, valueRenderer=ColumnNameTransformer.class)
    public PostgreTableColumn[] getColumnRefs() {
        return this.columnRefs;
    }

    @Property(viewable=true, order=6)
    public String getEnabledState() {
        return this.enabledState;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public PostgreTableBase getTable() {
        return this.table;
    }

    @Property(viewable=true, order=10)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=11)
    public String getWhenExpression() {
        return this.whenExpression;
    }

    @Property(viewable=true, order=12)
    public PostgreProcedure getFunction(DBRProgressMonitor monitor) throws DBException {
        if (this.functionId == 0L) {
            return null;
        }
        return this.getDatabase().getProcedure(monitor, this.functionSchemaId, this.functionId);
    }

    public void setFunction(PostgreProcedure function) {
        if (function == null) {
            this.functionId = 0L;
            this.functionSchemaId = 0L;
        } else {
            this.functionId = function.getObjectId();
            this.functionSchemaId = function.getSchema().getObjectId();
        }
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostgreTableReal getParentObject() {
        return this.table;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)this.table.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.table.getDatabase();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.body == null) {
            StringBuilder ddl = new StringBuilder();
            ddl.append("-- DROP TRIGGER ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" ON ").append(this.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read trigger definition");){
                    String triggerSource = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT pg_catalog.pg_get_triggerdef(?)", (Object[])new Object[]{this.objectId});
                    if (triggerSource != null) {
                        triggerSource = SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)triggerSource);
                        ddl.append(triggerSource).append(";");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
            if (!CommonUtils.isEmpty((String)this.getDescription()) && CommonUtils.getOption(options, (String)"pg.ddl.show.column.comments")) {
                ddl.append("\n").append("\nCOMMENT ON TRIGGER ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" ON ").append(this.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())).append(";");
            }
            this.body = ddl.toString();
        }
        return this.body;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.body = sourceText;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getParentObject(), this});
    }

    public DBSObjectState getObjectState() {
        if ("D".equals(this.enabledState)) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Refresh triggers state");){
            try {
                this.enabledState = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT tgenabled FROM pg_catalog.pg_trigger WHERE oid=?", (Object[])new Object[]{this.getObjectId()});
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }

    public static class ColumnNameTransformer
    implements IPropertyValueTransformer {
        public Object transform(Object object, Object value) throws IllegalArgumentException {
            if (value instanceof PostgreTableColumn[]) {
                StringBuilder sb = new StringBuilder();
                PostgreTableColumn[] postgreTableColumnArray = (PostgreTableColumn[])value;
                int n = postgreTableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PostgreTableColumn col = postgreTableColumnArray[n2];
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(col.getName());
                    ++n2;
                }
                return sb.toString();
            }
            return value;
        }
    }
}

