/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreViewManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerTypeRegistry;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreUtils {
    private static final Log log = Log.getLog(PostgreUtils.class);
    private static final int UNKNOWN_LENGTH = -1;

    public static String getObjectComment(DBRProgressMonitor monitor, GenericStructContainer container, String schema, String object) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load PostgreSQL description");){
                return JDBCUtils.queryString((JDBCSession)session, (String)"select description from pg_catalog.pg_description\njoin pg_catalog.pg_class on pg_description.objoid = pg_class.oid\njoin pg_catalog.pg_namespace on pg_class.relnamespace = pg_namespace.oid\nwhere pg_class.relname = ? and pg_namespace.nspname=?", (Object[])new Object[]{object, schema});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "bool";
            }
            case NUMERIC: {
                return "int";
            }
            case STRING: {
                return "varchar";
            }
            case DATETIME: {
                return "timestamp";
            }
            case BINARY: {
                return "bytea";
            }
            case CONTENT: {
                return "bytea";
            }
            case ROWID: {
                return "oid";
            }
        }
        return "varchar";
    }

    public static <T extends PostgreAttribute> T getAttributeByNum(Collection<T> attrs, int attNum) {
        for (PostgreAttribute attr : attrs) {
            if (attr.getOrdinalPosition() != attNum) continue;
            return (T)attr;
        }
        return null;
    }

    public static boolean isPGObject(Object object) {
        return object != null && object.getClass().getName().equals("org.postgresql.util.PGobject");
    }

    public static Object extractPGObjectValue(Object pgObject) {
        if (pgObject == null) {
            return null;
        }
        if (!pgObject.getClass().getName().equals("org.postgresql.util.PGobject")) {
            return pgObject;
        }
        try {
            return pgObject.getClass().getMethod("getValue", new Class[0]).invoke(pgObject, new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)"Can't extract value from PgObject", (Throwable)e);
            return null;
        }
    }

    public static boolean supportsTypeCategory(JDBCDataSource dataSource) {
        return dataSource.isServerVersionAtLeast(8, 4);
    }

    @Nullable
    public static <OWNER extends DBSObject, OBJECT extends PostgreObject> OBJECT getObjectById(@NotNull DBRProgressMonitor monitor, @NotNull AbstractObjectCache<OWNER, OBJECT> cache, @NotNull OWNER owner, long objectId) throws DBException {
        for (PostgreObject object : cache.getAllObjects(monitor, owner)) {
            if (object.getObjectId() != objectId) continue;
            return (OBJECT)object;
        }
        return null;
    }

    public static long[] getIdVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            long[] ids = new long[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Long.parseLong(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof long[]) {
            return (long[])pgVector;
        }
        if (pgVector instanceof Long[]) {
            Long[] objVector = (Long[])pgVector;
            long[] result = new long[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        if (pgVector instanceof Number) {
            return new long[]{((Number)pgVector).longValue()};
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int[] getIntVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            int[] ids = new int[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Integer.parseInt(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof int[]) {
            return (int[])pgVector;
        }
        if (pgVector instanceof Integer[]) {
            Integer[] objVector = (Integer[])pgVector;
            int[] result = new int[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        if (pgVector instanceof Number) {
            return new int[]{((Number)pgVector).intValue()};
        }
        if (pgVector instanceof java.sql.Array) {
            Object array;
            block16: {
                array = ((java.sql.Array)pgVector).getArray();
                if (array != null) break block16;
                return null;
            }
            try {
                int length = Array.getLength(array);
                int[] result = new int[length];
                int i = 0;
                while (i < length) {
                    Object item = Array.get(array, i);
                    if (item instanceof Number) {
                        result[i] = ((Number)item).intValue();
                    } else if (item != null) {
                        throw new IllegalArgumentException("Bad array item type: " + item.getClass().getName());
                    }
                    ++i;
                }
                return result;
            }
            catch (SQLException sQLException) {
                throw new IllegalArgumentException("Error reading array value: " + pgVector);
            }
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int getAttributePrecision(long typeOid, int typeMod) {
        switch ((int)typeOid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typeMod == -1) {
                    return 0;
                }
                return (typeMod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return PostgreUtils.getDisplaySize(typeOid, typeMod);
            }
            case 1560: {
                return typeMod;
            }
            case 1562: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod;
            }
        }
        return -1;
    }

    public static int getDisplaySize(long oid, int typmod) {
        switch ((int)oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch ((int)oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return -1;
            }
        }
        return -1;
    }

    public static int getScale(long oid, int typmod) {
        switch ((int)oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    public static PostgreDataType findDataType(DBCSession session, PostgreDataSource dataSource, DBSTypedObject type) throws DBCException {
        if (type instanceof PostgreDataType) {
            return (PostgreDataType)type;
        }
        if (type instanceof PostgreAttribute) {
            return ((PostgreAttribute)type).getDataType();
        }
        if (type instanceof JDBCColumnMetaData) {
            try {
                DBCEntityMetaData entityMetaData = ((DBCAttributeMetaData)type).getEntityMetaData();
                if (entityMetaData != null) {
                    DBSDataType dataType;
                    DBSEntityAttribute attribute;
                    DBSEntity docEntity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)session.getProgressMonitor(), (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)entityMetaData);
                    if (docEntity != null && (attribute = docEntity.getAttribute(session.getProgressMonitor(), ((DBCAttributeMetaData)type).getName())) instanceof DBSTypedObjectEx && (dataType = ((DBSTypedObjectEx)attribute).getDataType()) instanceof PostgreDataType) {
                        return (PostgreDataType)dataType;
                    }
                } else {
                    PostgreDataType dataType;
                    String databaseName = ((JDBCColumnMetaData)type).getCatalogName();
                    PostgreDatabase database = dataSource.getDatabase(databaseName);
                    if (database != null && (dataType = database.getDataType(session.getProgressMonitor(), type.getTypeName())) != null) {
                        return dataType;
                    }
                }
            }
            catch (DBException e) {
                throw new DBCException("Error extracting column " + type + " data type", (Throwable)e);
            }
        }
        String typeName = type.getTypeName();
        return dataSource.getLocalDataType(typeName);
    }

    public static void setArrayParameter(JDBCPreparedStatement dbStat, int index, List<? extends PostgreObject> objectList) throws SQLException {
        int i = 0;
        while (i < objectList.size()) {
            dbStat.setLong(index + i, objectList.get(i).getObjectId());
            ++i;
        }
    }

    public static String getViewDDL(DBRProgressMonitor monitor, PostgreViewBase view, String definition) throws DBException {
        if (definition.toLowerCase(Locale.ENGLISH).startsWith("create ")) {
            return definition;
        }
        StringBuilder sql = new StringBuilder(view instanceof PostgreView ? "CREATE OR REPLACE " : "CREATE ");
        sql.append(view.getViewType()).append(" ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL));
        DBERegistry editorsRegistry = ((PostgreDataSource)view.getDataSource()).getContainer().getPlatform().getEditorsRegistry();
        PostgreViewManager entityEditor = (PostgreViewManager)((Object)editorsRegistry.getObjectManager(view.getClass(), PostgreViewManager.class));
        if (entityEditor != null) {
            entityEditor.appendViewDeclarationPrefix(monitor, sql, view);
        }
        definition = definition.trim();
        while (definition.endsWith(";")) {
            definition = definition.substring(0, definition.length() - 1);
        }
        sql.append("\nAS ").append(definition);
        if (entityEditor != null) {
            entityEditor.appendViewDeclarationPostfix(monitor, sql, view);
        }
        sql.append(";");
        return sql.toString();
    }

    public static PostgreServerType getServerType(DBPDriver driver) {
        PostgreServerType serverType;
        String serverTypeName = CommonUtils.toString((Object)driver.getDriverParameter("serverType"));
        if (CommonUtils.isEmpty((String)serverTypeName)) {
            serverTypeName = "postgresql";
        }
        if ((serverType = PostgreServerTypeRegistry.getInstance().getServerType(serverTypeName)) == null) {
            throw new IllegalStateException("PostgreSQL server type '" + serverTypeName + "' not found");
        }
        return serverType;
    }

    public static List<PostgrePrivilege> extractPermissionsFromACL(DBRProgressMonitor monitor, @NotNull PostgrePrivilegeOwner owner, @Nullable Object acl) throws DBException {
        Object itemArray;
        if (!(acl instanceof java.sql.Array)) {
            if (acl == null) {
                PostgreRole objectOwner = owner.getOwner(monitor);
                String granteeName = objectOwner == null ? null : objectOwner.getName();
                ArrayList<PostgrePrivilegeGrant> privileges = new ArrayList<PostgrePrivilegeGrant>();
                privileges.add(new PostgrePrivilegeGrant(granteeName, granteeName, owner.getDatabase().getName(), owner.getSchema().getName(), owner.getName(), PostgrePrivilegeType.ALL, false, false));
                PostgreObjectPrivilege permission = new PostgreObjectPrivilege(owner, objectOwner == null ? null : objectOwner.getName(), privileges);
                return Collections.singletonList(permission);
            }
            return Collections.emptyList();
        }
        try {
            itemArray = ((java.sql.Array)acl).getArray();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        int itemCount = Array.getLength(itemArray);
        int i = 0;
        while (i < itemCount) {
            Object aclItem = Array.get(itemArray, i);
            String aclValue = CommonUtils.toString((Object)PostgreUtils.extractPGObjectValue(aclItem));
            if (!CommonUtils.isEmpty((String)aclValue)) {
                int divPos = aclValue.indexOf(61);
                if (divPos == -1) {
                    log.warn((Object)("Bad ACL item: " + aclValue));
                } else {
                    String permString;
                    int divPos2;
                    String grantee = aclValue.substring(0, divPos);
                    if (grantee.isEmpty()) {
                        grantee = "public";
                    }
                    if ((divPos2 = (permString = aclValue.substring(divPos + 1)).indexOf(47)) == -1) {
                        log.warn((Object)("Bad permissions string: " + permString));
                    } else {
                        String privString = permString.substring(0, divPos2);
                        String grantor = permString.substring(divPos2 + 1);
                        ArrayList<PostgrePrivilegeGrant> privileges = new ArrayList<PostgrePrivilegeGrant>();
                        int k = 0;
                        while (k < privString.length()) {
                            char pCode = privString.charAt(k);
                            boolean withGrantOption = false;
                            if (k < privString.length() - 1 && privString.charAt(k + 1) == '*') {
                                withGrantOption = true;
                                ++k;
                            }
                            privileges.add(new PostgrePrivilegeGrant(grantor, grantee, owner.getDatabase().getName(), owner.getSchema().getName(), owner.getName(), PostgrePrivilegeType.getByCode(pCode), withGrantOption, false));
                            ++k;
                        }
                        permissions.add(new PostgreObjectPrivilege(owner, grantee, privileges));
                    }
                }
            }
            ++i;
        }
        return permissions;
    }

    public static String getOptionsString(String[] options) {
        StringBuilder opt = new StringBuilder();
        opt.append("(");
        if (!ArrayUtils.isEmpty((Object[])options)) {
            int i = 0;
            while (i < options.length) {
                int divPos;
                String option = options[i];
                if (i > 0) {
                    opt.append(", ");
                }
                if ((divPos = option.indexOf(61)) < 0) {
                    opt.append(option);
                } else {
                    opt.append(option.substring(0, divPos)).append(" '").append(option.substring(divPos + 1)).append("'");
                }
                ++i;
            }
        }
        opt.append(")");
        return opt.toString();
    }

    public static String getObjectTypeName(PostgrePrivilegeOwner object) {
        if (object instanceof PostgreSequence) {
            return "SEQUENCE";
        }
        if (object instanceof PostgreProcedure) {
            return ((PostgreProcedure)object).getProcedureTypeName();
        }
        if (object instanceof PostgreSchema) {
            return "SCHEMA";
        }
        if (object instanceof PostgreDatabase) {
            return "DATABASE";
        }
        return "TABLE";
    }

    public static String getObjectUniqueName(PostgrePrivilegeOwner object) {
        if (object instanceof PostgreProcedure) {
            return ((PostgreProcedure)object).getFullQualifiedSignature();
        }
        return DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
    }

    public static void getObjectGrantPermissionActions(DBRProgressMonitor monitor, PostgrePrivilegeOwner object, List<DBEPersistAction> actions, Map<String, Object> options) throws DBException {
        if (object.isPersisted() && CommonUtils.getOption(options, (String)"pg.ddl.show.permissions")) {
            Collection<PostgrePrivilege> permissions;
            String alterScript;
            DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)object, (boolean)true);
            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)object.getDataSource(), "Permissions"));
            PostgreRole owner = object.getOwner(monitor);
            if (owner != null && !CommonUtils.isEmpty((String)(alterScript = object.generateChangeOwnerQuery(DBUtils.getQuotedIdentifier((DBSObject)owner))))) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Owner change", alterScript));
            }
            if (!CommonUtils.isEmpty(permissions = object.getPrivileges(monitor, true))) {
                for (PostgrePrivilege permission : permissions) {
                    if (permission.hasAllPrivileges(object)) {
                        Collections.addAll(actions, new PostgreCommandGrantPrivilege(permission.getOwner(), true, permission, new PostgrePrivilegeType[]{PostgrePrivilegeType.ALL}).getPersistActions(monitor, executionContext, options));
                        continue;
                    }
                    PostgreCommandGrantPrivilege grant = new PostgreCommandGrantPrivilege(permission.getOwner(), true, permission, permission.getPrivileges());
                    Collections.addAll(actions, grant.getPersistActions(monitor, executionContext, options));
                }
            }
        }
    }

    public static boolean isGISDataType(String typeName) {
        return "geometry".equals(typeName) || "geography".equals(typeName);
    }

    public static String getRealSchemaName(PostgreDatabase database, String name) {
        return name.replace("$user", database.getMetaContext().getActiveUser());
    }
}

