/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser.rules;

import org.eclipse.core.runtime.Assert;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class NumberRule
implements TPRule {
    protected static final int UNDEFINED = -1;
    protected TPToken fToken;
    protected int fColumn = -1;

    public NumberRule(TPToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int c = scanner.read();
        if (Character.isDigit((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            int charNum = 0;
            while (Character.isDigit((char)(c = scanner.read())) || ++charNum > 0 && Character.toLowerCase(c) == 101) {
            }
            scanner.unread();
            return this.fToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }
}

