/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.Method;
import java.text.Format;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DefaultNavigatorNodeRenderer;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class StatisticsNavigatorNodeRenderer
extends DefaultNavigatorNodeRenderer {
    private static final Log log = Log.getLog(StatisticsNavigatorNodeRenderer.class);
    private static final int PERCENT_FILL_WIDTH = 50;
    private final ByteNumberFormat numberFormat = new ByteNumberFormat();
    private final Map<String, Format> classFormatMap = new HashMap<String, Format>();
    private static final Map<DBSObject, StatReadJob> statReaders = new IdentityHashMap<DBSObject, StatReadJob>();
    private Font fontItalic;

    public Font getFontItalic(Tree tree) {
        if (this.fontItalic == null) {
            this.fontItalic = UIUtils.modifyFont((Font)tree.getFont(), (int)2);
            tree.addDisposeListener(e -> UIUtils.dispose((Resource)this.fontItalic));
        }
        return this.fontItalic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintNodeDetails(DBNNode node, Tree tree, GC gc, Event event) {
        super.paintNodeDetails(node, tree, gc, event);
        Object element = event.item.getData();
        if (element instanceof DBNDatabaseNode) {
            DBSObject object;
            DBPDataSourceContainer dataSourceContainer;
            DBPConnectionConfiguration configuration;
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.connection.host") && element instanceof DBNDataSource && !CommonUtils.isEmpty((String)(configuration = (dataSourceContainer = ((DBNDataSource)element).getDataSourceContainer()).getConnectionConfiguration()).getHostName())) {
                DBPDataSourceContainer ds;
                Color bgColor;
                Font oldFont = gc.getFont();
                String hostText = configuration.getHostName();
                if (hostText.equals("localhost") || hostText.equals("127.0.0.1")) {
                    for (DBWHandlerConfiguration hc : configuration.getHandlers()) {
                        String tunnelHost;
                        if (!hc.isEnabled() || hc.getType() != DBWHandlerType.TUNNEL || CommonUtils.isEmpty((String)(tunnelHost = hc.getStringProperty("host")))) continue;
                        hostText = tunnelHost;
                        break;
                    }
                }
                gc.setForeground((bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)(ds = ((DBNDatabaseNode)element).getDataSourceContainer()).getConnectionConfiguration())) == null ? tree.getDisplay().getSystemColor(UIStyles.isDarkTheme() ? 19 : 18) : UIUtils.getContrastColor((Color)bgColor));
                gc.setFont(this.getFontItalic(tree));
                gc.drawText(" - " + hostText, event.x + event.width + 2, event.y, true);
                gc.setFont(oldFont);
            }
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.statistics.info") && (object = ((DBNDatabaseNode)element).getObject()) instanceof DBPObjectStatistics) {
                int xShift;
                int treeWidth;
                String sizeText;
                int percentFull;
                long maxObjectSize;
                boolean statsWasRead = false;
                DBSObject parentObject = DBUtils.getPublicObject((DBSObject)object.getParentObject());
                if (parentObject instanceof DBPObjectStatisticsCollector) {
                    statsWasRead = ((DBPObjectStatisticsCollector)parentObject).isStatisticsCollected();
                }
                long l = maxObjectSize = statsWasRead ? this.getMaxObjectSize((TreeItem)event.item) : -1L;
                if (statsWasRead && maxObjectSize >= 0L) {
                    Format format;
                    long statObjectSize = ((DBPObjectStatistics)object).getStatObjectSize();
                    if (statObjectSize <= 0L) {
                        return;
                    }
                    int n = percentFull = maxObjectSize == 0L ? 0 : (int)(statObjectSize * 100L / maxObjectSize);
                    if (percentFull < 0 || percentFull > 100) {
                        log.debug((Object)"Object stat > 100%!");
                        percentFull = 100;
                    }
                    Map<String, Format> map = this.classFormatMap;
                    synchronized (map) {
                        format = this.classFormatMap.get(object.getClass().getName());
                        if (format == null) {
                            try {
                                Class formatterClass;
                                Method getStatObjectSizeMethod = object.getClass().getMethod("getStatObjectSize", new Class[0]);
                                Property propAnnotation = getStatObjectSizeMethod.getAnnotation(Property.class);
                                if (propAnnotation != null && (formatterClass = propAnnotation.formatter()) != Format.class) {
                                    format = (Format)formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                            }
                            catch (Exception e) {
                                log.debug((Object)e);
                            }
                            if (format == null) {
                                format = this.numberFormat;
                            }
                            this.classFormatMap.put(object.getClass().getName(), format);
                        }
                    }
                    sizeText = format.format(statObjectSize);
                } else {
                    sizeText = "...";
                    percentFull = 0;
                    DBNNode parentNode = ((DBNDatabaseNode)element).getParentNode();
                    while (parentNode instanceof DBNDatabaseFolder) {
                        parentNode = parentNode.getParentNode();
                    }
                    if (parentNode instanceof DBNDatabaseNode && !this.readObjectStatistics((DBNDatabaseNode)parentNode, ((TreeItem)event.item).getParentItem())) {
                        return;
                    }
                }
                Point textSize = gc.stringExtent(sizeText);
                textSize.x += 4;
                int cfr_ignored_0 = tree.getClientArea().width;
                int occupiedWidth = event.x + event.width + 4;
                ScrollBar hSB = tree.getHorizontalBar();
                if (hSB == null || !hSB.isVisible()) {
                    treeWidth = tree.getClientArea().width;
                    xShift = 0;
                } else {
                    treeWidth = hSB.getMaximum();
                    xShift = hSB.getSelection();
                }
                int xWidth = treeWidth - xShift;
                if (xWidth - occupiedWidth > Math.max(50, textSize.x)) {
                    CTabFolder tabFolder = (CTabFolder)UIUtils.getParentOfType((Control)tree, CTabFolder.class);
                    Color fillColor = tabFolder == null ? UIStyles.getDefaultWidgetBackground() : tabFolder.getBackground();
                    gc.setBackground(fillColor);
                    int fillWidth = 50 * percentFull / 100 + 1;
                    int x = xWidth - fillWidth - 2;
                    gc.fillRectangle(x, event.y + 2, fillWidth, event.height - 4);
                    gc.setForeground(tree.getForeground());
                    int x2 = xWidth - textSize.x - 2;
                    gc.drawText(sizeText, x2 + 2, event.y, true);
                }
            }
        }
    }

    private long getMaxObjectSize(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        Object maxSize = parentItem.getData("nav.stat.maxSize");
        if (maxSize instanceof Number) {
            return ((Number)maxSize).longValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readObjectStatistics(DBNDatabaseNode parentNode, TreeItem parentItem) {
        DBSObject parentObject = DBUtils.getPublicObject((DBSObject)parentNode.getObject());
        if (parentObject instanceof DBPObjectStatisticsCollector) {
            Map<DBSObject, StatReadJob> map = statReaders;
            synchronized (map) {
                StatReadJob statReadJob = statReaders.get(parentObject);
                if (statReadJob == null) {
                    statReadJob = new StatReadJob(parentObject, parentItem);
                    statReaders.put(parentObject, statReadJob);
                    statReadJob.schedule();
                }
            }
            return true;
        }
        return false;
    }

    private static class StatReadJob
    extends AbstractJob {
        private final DBSObject collector;
        private final TreeItem treeItem;

        StatReadJob(DBSObject collector, TreeItem treeItem) {
            super("Read statistics for " + DBUtils.getObjectFullName((DBPNamedObject)collector, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.collector = collector;
            this.treeItem = treeItem;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                Collection children;
                ((DBPObjectStatisticsCollector)this.collector).collectObjectStatistics(monitor, false, false);
                long maxStatSize = 0L;
                if (this.collector instanceof DBSObjectContainer && (children = ((DBSObjectContainer)this.collector).getChildren(monitor)) != null) {
                    for (DBSObject child : children) {
                        if (!(child instanceof DBPObjectStatistics)) continue;
                        long statObjectSize = ((DBPObjectStatistics)child).getStatObjectSize();
                        maxStatSize = Math.max(maxStatSize, statObjectSize);
                    }
                }
                long finalMaxStatSize = maxStatSize;
                UIUtils.asyncExec(() -> {
                    try {
                        if (!this.treeItem.isDisposed()) {
                            this.treeItem.setData("nav.stat.maxSize", (Object)finalMaxStatSize);
                            this.treeItem.getParent().redraw();
                        }
                    }
                    catch (Throwable throwable) {
                        Map map = statReaders;
                        synchronized (map) {
                            statReaders.remove(this.collector);
                        }
                        throw throwable;
                    }
                    Map map = statReaders;
                    synchronized (map) {
                        statReaders.remove(this.collector);
                    }
                });
            }
            catch (DBException e) {
                log.error((Object)e);
            }
            return Status.OK_STATUS;
        }
    }
}

