/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorItemRenderer;

public class DefaultNavigatorNodeRenderer
implements DatabaseNavigatorItemRenderer {
    @Override
    public void drawNodeBackground(DBNNode node, Tree tree, GC gc, Event event) {
    }

    @Override
    public void paintNodeDetails(DBNNode node, Tree tree, GC gc, Event event) {
        Color conColor = null;
        Object element = event.item.getData();
        if (element instanceof DBNDatabaseNode) {
            DBPDataSourceContainer ds = ((DBNDatabaseNode)element).getDataSourceContainer();
            conColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)ds.getConnectionConfiguration());
        }
        if (conColor != null) {
            gc.setForeground(conColor);
            if (!(element instanceof DBNDataSource)) {
                int oldLineWidth = gc.getLineWidth();
                gc.setForeground(conColor);
                gc.setLineWidth(3);
                if (((TreeItem)event.item).getItemCount() > 0) {
                    gc.drawLine(event.x - 20, event.y - 1, event.x - 20, event.y + event.height + 1);
                } else {
                    gc.drawLine(event.x - 4, event.y - 1, event.x - 4, event.y + event.height + 1);
                }
                gc.setLineWidth(oldLineWidth);
            }
        }
    }
}

