/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ByteNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    private static final String B = "b";
    private static final String KB = "Kb";
    private static final String MB = "Mb";
    private static final String GB = "Gb";
    private static final String TB = "Tb";
    private static final String PB = "Pb";
    public static final String[] BYTES = new String[]{"b", "Kb", "Mb", "Gb", "Tb", "Pb"};
    private static final DecimalFormat fpFormat = new DecimalFormat("#.#");

    public static int computeIndex(double bytes) {
        int index = 0;
        int i = 0;
        while (i < BYTES.length) {
            int result = (int)(bytes / 1024.0);
            if (result == 0 || (bytes /= 1024.0) < 1.0) break;
            ++index;
            ++i;
        }
        return index;
    }

    public String getBytes(double bytes) {
        int index = ByteNumberFormat.computeIndex(bytes);
        double intBytes = bytes;
        if (intBytes == 0.0) {
            return String.valueOf(0);
        }
        int i = 0;
        while (i < index) {
            intBytes /= 1024.0;
            ++i;
        }
        String str = (long)intBytes >= 10L ? String.valueOf((long)intBytes) : fpFormat.format(intBytes);
        return String.valueOf(str) + BYTES[index];
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new ByteNumberFormat().format(100L));
        System.out.println(new ByteNumberFormat().format(1000L));
        System.out.println(new ByteNumberFormat().format(10000L));
        System.out.println(new ByteNumberFormat().format(11000L));
        System.out.println(new ByteNumberFormat().format(100000L));
        System.out.println(new ByteNumberFormat().format(1000000L));
        System.out.println(new ByteNumberFormat().format(10000000L));
    }
}

