/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class DBXTreeItem
extends DBXTreeNode {
    private String label;
    private String itemLabel;
    private String path;
    private String propertyName;
    private boolean optional;
    private Map<Class<?>, Method> propertyGettersCache = new IdentityHashMap();
    private static final Method NULL_GETTER;

    static {
        Method dummyMethod;
        try {
            dummyMethod = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            dummyMethod = null;
        }
        NULL_GETTER = dummyMethod;
    }

    public DBXTreeItem(AbstractDescriptor source, DBXTreeNode parent, IConfigurationElement config, String path, String propertyName, boolean optional, boolean navigable, boolean inline, boolean virtual, boolean standalone, String visibleIf, String recursiveLink) {
        super(source, parent, config, navigable, inline, virtual, standalone, visibleIf, recursiveLink);
        this.label = parent == null ? ModelMessages.model_navigator_Connection : config.getAttribute("label");
        String string = this.itemLabel = parent == null ? ModelMessages.model_navigator_Connection : config.getAttribute("itemLabel");
        if (this.itemLabel == null) {
            this.itemLabel = this.label;
        }
        this.path = path;
        this.propertyName = propertyName;
        this.optional = optional;
    }

    public DBXTreeItem(AbstractDescriptor source, DBXTreeNode parent, DBXTreeItem item) {
        super(source, parent, item);
        this.label = item.label;
        this.itemLabel = item.itemLabel;
        this.path = item.path;
        this.propertyName = item.propertyName;
        this.optional = item.optional;
    }

    public String getPath() {
        return this.path;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String getChildrenTypeLabel(@Nullable DBPDataSource dataSource, String locale) {
        String term = this.getNodeTerm(dataSource, this.label, true);
        if (term != null) {
            return term;
        }
        return this.label;
    }

    @Override
    public String getNodeTypeLabel(@Nullable DBPDataSource dataSource, @Nullable String locale) {
        String term = this.getNodeTerm(dataSource, this.itemLabel, false);
        if (term != null) {
            return term;
        }
        return this.itemLabel;
    }

    private String getNodeTerm(@Nullable DBPDataSource dataSource, String termId, boolean multiple) {
        String term;
        if (termId.startsWith("#") && dataSource instanceof DBPTermProvider && (term = ((DBPTermProvider)((Object)dataSource)).getObjectTypeTerm(this.getPath(), termId.substring(1), multiple)) != null) {
            return term;
        }
        return null;
    }

    public DBXTreeItem findChildItemByPath(String path) {
        for (DBXTreeNode node : this.getChildren()) {
            DBXTreeItem subItem = this.findChildItemByPath(node, path);
            if (subItem == null) continue;
            return subItem;
        }
        return null;
    }

    private DBXTreeItem findChildItemByPath(DBXTreeNode node, String path) {
        if (node instanceof DBXTreeItem && CommonUtils.equalObjects((Object)((DBXTreeItem)node).getPath(), (Object)path)) {
            return (DBXTreeItem)node;
        }
        if (node instanceof DBXTreeFolder) {
            for (DBXTreeNode subFolder : node.getChildren()) {
                DBXTreeItem subItem = this.findChildItemByPath(subFolder, path);
                if (subItem == null) continue;
                return subItem;
            }
        }
        return null;
    }

    public synchronized Method getPropertyReadMethod(Class<?> objectClass) {
        Method getter = this.propertyGettersCache.get(objectClass);
        if (getter == null) {
            getter = DBXTreeItem.findPropertyReadMethod(objectClass, this.propertyName);
            if (getter == null) {
                getter = NULL_GETTER;
            }
            this.propertyGettersCache.put(objectClass, getter);
        }
        return getter == NULL_GETTER ? null : getter;
    }

    private static Method findPropertyReadMethod(Class<?> clazz, String propertyName) {
        String methodName = BeanUtils.propertyNameToMethodName((String)propertyName);
        return DBXTreeItem.findPropertyGetter(clazz, "get" + methodName, "is" + methodName);
    }

    private static Method findPropertyGetter(Class<?> clazz, String getName, String isName) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) && !method.getReturnType().equals(Void.TYPE) && (method.getName().equals(getName) || method.getName().equals(isName) && method.getReturnType().equals(Boolean.TYPE)) && ((parameterTypes = method.getParameterTypes()).length == 0 || parameterTypes.length == 1 && parameterTypes[0] == DBRProgressMonitor.class)) {
                return method;
            }
            ++n2;
        }
        return clazz == Object.class ? null : DBXTreeItem.findPropertyGetter(clazz.getSuperclass(), getName, isName);
    }

    @Override
    public String toString() {
        return "Item " + this.label;
    }
}

