/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageErrorHandle
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.errorHandle";
    private Spinner connectionOpenTimeout;
    private Spinner connectionCloseTimeout;
    private Spinner connectionValidateTimeout;
    private Button rollbackOnErrorCheck;
    private Button connectionAutoRecoverEnabled;
    private Spinner connectionAutoRecoverRetryCount;
    private Spinner cancelCheckTimeout;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("connection.open.timeout") || store.contains("connection.close.timeout") || store.contains("connection.validation.timeout") || store.contains("query.rollback-on-error") || store.contains("execute.recover.enabled") || store.contains("execute.recover.retryCount") || store.contains("execute.cancel.checkTimeout");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group timeoutsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_error_handle_group_timeouts_title, (int)2, (int)2, (int)0);
        this.connectionOpenTimeout = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)(String.valueOf(CoreMessages.pref_page_error_handle_connection_open_timeout_label) + UIMessages.label_ms), (String)CoreMessages.pref_page_error_handle_connection_open_timeout_label_tip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.connectionCloseTimeout = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)(String.valueOf(CoreMessages.pref_page_error_handle_connection_close_timeout_label) + UIMessages.label_ms), (String)CoreMessages.pref_page_error_handle_connection_close_timeout_label_tip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.connectionValidateTimeout = UIUtils.createLabelSpinner((Composite)timeoutsGroup, (String)(String.valueOf(CoreMessages.pref_page_error_handle_connection_validate_timeout_label) + UIMessages.label_ms), (String)CoreMessages.pref_page_error_handle_connection_validate_timeout_label_tip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group errorGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_error_handle_group_execute_title, (int)2, (int)2, (int)0);
        this.rollbackOnErrorCheck = UIUtils.createCheckbox((Composite)errorGroup, (String)CoreMessages.pref_page_database_general_checkbox_rollback_on_error, null, (boolean)false, (int)2);
        this.connectionAutoRecoverEnabled = UIUtils.createCheckbox((Composite)errorGroup, (String)CoreMessages.pref_page_error_handle_recover_enabled_label, (String)CoreMessages.pref_page_error_handle_recover_enabled_tip, (boolean)false, (int)2);
        this.connectionAutoRecoverRetryCount = UIUtils.createLabelSpinner((Composite)errorGroup, (String)CoreMessages.pref_page_error_handle_recover_retry_count_label, (String)CoreMessages.pref_page_error_handle_recover_retry_count_tip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        errorGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_error_handle_group_cancel_title, (int)2, (int)2, (int)0);
        this.cancelCheckTimeout = UIUtils.createLabelSpinner((Composite)errorGroup, (String)CoreMessages.pref_page_error_handle_cancel_check_timeout, (String)CoreMessages.pref_page_error_handle_cancel_check_timeout_tip, (int)0, (int)0, (int)Integer.MAX_VALUE);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.connectionOpenTimeout.setSelection(store.getInt("connection.open.timeout"));
            this.connectionCloseTimeout.setSelection(store.getInt("connection.close.timeout"));
            this.connectionValidateTimeout.setSelection(store.getInt("connection.validation.timeout"));
            this.rollbackOnErrorCheck.setSelection(store.getBoolean("query.rollback-on-error"));
            this.connectionAutoRecoverEnabled.setSelection(store.getBoolean("execute.recover.enabled"));
            this.connectionAutoRecoverRetryCount.setSelection(store.getInt("execute.recover.retryCount"));
            this.cancelCheckTimeout.setSelection(store.getInt("execute.cancel.checkTimeout"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("connection.open.timeout", this.connectionOpenTimeout.getSelection());
            store.setValue("connection.close.timeout", this.connectionCloseTimeout.getSelection());
            store.setValue("connection.validation.timeout", this.connectionValidateTimeout.getSelection());
            store.setValue("query.rollback-on-error", this.rollbackOnErrorCheck.getSelection());
            store.setValue("execute.recover.enabled", this.connectionAutoRecoverEnabled.getSelection());
            store.setValue("execute.recover.retryCount", this.connectionAutoRecoverRetryCount.getSelection());
            store.setValue("execute.cancel.checkTimeout", this.cancelCheckTimeout.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("connection.open.timeout");
        store.setToDefault("connection.close.timeout");
        store.setToDefault("connection.validation.timeout");
        store.setToDefault("query.rollback-on-error");
        store.setToDefault("execute.recover.enabled");
        store.setToDefault("execute.recover.retryCount");
        store.setToDefault("execute.cancel.checkTimeout");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

