/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Index {
    private String type;
    private String using;
    private List<ColumnParams> columns;
    private final List<String> name = new ArrayList<String>();
    private List<String> idxSpec;

    public List<String> getColumnsNames() {
        return this.columns.stream().map(col -> col.columnName).collect(Collectors.toList());
    }

    public List<ColumnParams> getColumnWithParams() {
        return this.columns;
    }

    public String getName() {
        return this.name.isEmpty() ? null : String.join((CharSequence)".", this.name);
    }

    public List<String> getNameParts() {
        return Collections.unmodifiableList(this.name);
    }

    public String getType() {
        return this.type;
    }

    public void setUsing(String string) {
        this.using = string;
    }

    public void setColumnsNames(List<String> list) {
        this.columns = list.stream().map(col -> new ColumnParams((String)col, null)).collect(Collectors.toList());
    }

    public void setColumnNamesWithParams(List<ColumnParams> list) {
        this.columns = list;
    }

    public void setName(String name) {
        this.name.clear();
        this.name.add(name);
    }

    public void setName(List<String> name) {
        this.name.clear();
        this.name.addAll(name);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getUsing() {
        return this.using;
    }

    public List<String> getIndexSpec() {
        return this.idxSpec;
    }

    public void setIndexSpec(List<String> idxSpec) {
        this.idxSpec = idxSpec;
    }

    public String toString() {
        String idxSpecText = PlainSelect.getStringList(this.idxSpec, false, false);
        return this.type + (!this.name.isEmpty() ? " " + this.getName() : "") + " " + PlainSelect.getStringList(this.columns, true, true) + (!"".equals(idxSpecText) ? " " + idxSpecText : "");
    }

    public static class ColumnParams {
        public final String columnName;
        public final List<String> params;

        public ColumnParams(String columnName, List<String> params) {
            this.columnName = columnName;
            this.params = params;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public List<String> getParams() {
            return this.params;
        }

        public String toString() {
            return this.columnName + (this.params != null ? " " + String.join((CharSequence)" ", this.params) : "");
        }
    }
}

