/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;

public class MySQLTableUniqueKey
extends MySQLTableConstraintBase {
    private List<MySQLTableConstraintColumn> columns;

    public MySQLTableUniqueKey(MySQLTable table, String name, String remarks, DBSEntityConstraintType constraintType, boolean persisted) {
        super(table, name, remarks, constraintType, persisted);
    }

    protected MySQLTableUniqueKey(DBRProgressMonitor monitor, MySQLTable table, DBSEntityConstraint source) throws DBException {
        super(table, source, false);
        List columns;
        if (source instanceof DBSEntityReferrer && (columns = ((DBSEntityReferrer)source).getAttributeReferences(monitor)) != null) {
            this.columns = new ArrayList<MySQLTableConstraintColumn>(columns.size());
            for (DBSEntityAttributeRef col : columns) {
                if (col.getAttribute() == null) continue;
                MySQLTableColumn ownCol = table.getAttribute(monitor, col.getAttribute().getName());
                this.columns.add(new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable>)this, ownCol, col.getAttribute().getOrdinalPosition()));
            }
        }
    }

    public List<MySQLTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addColumn(MySQLTableConstraintColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<MySQLTableConstraintColumn>();
        }
        this.columns.add(column);
    }

    void setColumns(List<MySQLTableConstraintColumn> columns) {
        this.columns = columns;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((MySQLTable)this.getTable()).getContainer(), this.getTable(), this});
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)((MySQLTable)this.getTable()).getDataSource();
    }
}

