/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor.tools;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.ext.erd.part.ICustomizablePart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.part.NotePart;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class SetPartSettingsAction
extends SelectionAction {
    private IStructuredSelection selection;

    public SetPartSettingsAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText("Customize ...");
        this.setToolTipText("Figure node view settings");
        this.setId("setPartSettings");
    }

    protected boolean calculateEnabled() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof NodePart) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(){
            private ViewSettings newSettings;
            private final Map<ICustomizablePart, ViewSettings> oldSettings = new HashMap<ICustomizablePart, ViewSettings>();

            public void execute() {
                Shell shell = UIUtils.createCenteredShell((Shell)SetPartSettingsAction.this.getWorkbenchPart().getSite().getShell());
                try {
                    NodePart nodePart = null;
                    boolean hasNotes = false;
                    boolean hasEntities = false;
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item instanceof NodePart) {
                            if (nodePart == null) {
                                nodePart = (NodePart)item;
                            }
                            if (item instanceof NotePart) {
                                hasNotes = true;
                            } else if (item instanceof EntityPart) {
                                hasEntities = true;
                            }
                        }
                        ++n2;
                    }
                    PartSettingsDialog settingsDialog = new PartSettingsDialog(shell, nodePart, hasNotes, hasEntities);
                    if (settingsDialog.open() != 0) {
                        return;
                    }
                    this.newSettings = settingsDialog.newSettings;
                    Object[] objectArray2 = objects;
                    int n3 = objects.length;
                    n = 0;
                    while (n < n3) {
                        Object item = objectArray2[n];
                        if (item instanceof ICustomizablePart) {
                            ICustomizablePart part = (ICustomizablePart)item;
                            ViewSettings oldSettings = new ViewSettings();
                            oldSettings.transparency = part.getCustomTransparency();
                            oldSettings.background = part.getCustomBackgroundColor();
                            oldSettings.foreground = part.getCustomForegroundColor();
                            oldSettings.borderWidth = part.getCustomBorderWidth();
                            oldSettings.fontInfo = SharedFonts.toString((Font)part.getCustomFont());
                            this.oldSettings.put(part, oldSettings);
                            this.setNodeSettings(part, this.newSettings);
                        }
                        ++n;
                    }
                }
                finally {
                    UIUtils.disposeCenteredShell((Shell)shell);
                }
            }

            public void undo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    ICustomizablePart colorizedPart;
                    ViewSettings viewSettings;
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart && (viewSettings = this.oldSettings.get(colorizedPart = (ICustomizablePart)item)) != null) {
                        this.setNodeSettings(colorizedPart, viewSettings);
                    }
                    ++n2;
                }
            }

            public void redo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        this.setNodeSettings((ICustomizablePart)item, this.newSettings);
                    }
                    ++n2;
                }
            }

            private void setNodeSettings(ICustomizablePart part, ViewSettings settings) {
                if (part instanceof NotePart) {
                    part.setCustomTransparency(settings.transparency);
                }
                part.setCustomBackgroundColor(settings.background);
                if (part instanceof NotePart) {
                    part.setCustomForegroundColor(settings.foreground);
                    part.setCustomBorderWidth(settings.borderWidth);
                    part.setCustomFont(UIUtils.getSharedFonts().getFont((Device)Display.getCurrent(), settings.fontInfo));
                }
            }
        };
    }

    private static class PartSettingsDialog
    extends BaseDialog {
        private final NodePart node;
        private final boolean noteStyles;
        private final boolean entityStyles;
        private Button transparentCheckbox;
        private ColorSelector backgroundColorPicker;
        private ColorSelector foregroundColorPicker;
        private Text borderWidthText;
        private String fontData;
        private ViewSettings newSettings = new ViewSettings();

        public PartSettingsDialog(Shell parentShell, NodePart node, boolean noteStyles, boolean entityStyles) {
            super(parentShell, "Node view settings", null);
            this.node = node;
            this.noteStyles = noteStyles;
            this.entityStyles = entityStyles;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            final Group settingsGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Settings", (int)2, (int)768, (int)0);
            if (this.noteStyles) {
                this.transparentCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)"Transparent", (String)"Make figure transparent (no background)", (this.node != null && this.node.getCustomTransparency() ? 1 : 0) != 0, (int)2);
            }
            UIUtils.createControlLabel((Composite)settingsGroup, (String)"Background");
            this.backgroundColorPicker = new ColorSelector((Composite)settingsGroup);
            if (this.node != null) {
                this.backgroundColorPicker.setColorValue(this.node.getCustomBackgroundColor().getRGB());
            }
            if (this.noteStyles) {
                UIUtils.createControlLabel((Composite)settingsGroup, (String)"Foreground");
                this.foregroundColorPicker = new ColorSelector((Composite)settingsGroup);
                if (this.node != null) {
                    this.foregroundColorPicker.setColorValue(this.node.getCustomForegroundColor().getRGB());
                }
                this.borderWidthText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Border width", (String)String.valueOf(this.node == null ? 1 : this.node.getCustomBorderWidth()));
                GridData gd = new GridData(32);
                gd.widthHint = 30;
                this.borderWidthText.setLayoutData((Object)gd);
                this.borderWidthText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
                UIUtils.createControlLabel((Composite)settingsGroup, (String)"Font");
                Button changeFontButton = UIUtils.createPushButton((Composite)settingsGroup, (String)"Customize...", null, null);
                changeFontButton.setLayoutData((Object)new GridData(2));
                final Text previewText = new Text((Composite)settingsGroup, 2058);
                previewText.setText("ERD Node Text");
                gd = new GridData(770);
                gd.horizontalSpan = 2;
                previewText.setLayoutData((Object)gd);
                if (this.node != null) {
                    previewText.setFont(this.node.getCustomFont());
                    this.fontData = SharedFonts.toString((FontData)this.node.getCustomFont().getFontData()[0]);
                }
                changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FontDialog fontDialog = new FontDialog(this.getShell(), 0);
                        fontDialog.setFontList(previewText.getFont().getFontData());
                        FontData result = fontDialog.open();
                        if (result != null) {
                            fontData = SharedFonts.toString((FontData)result);
                            previewText.setFont(UIUtils.getSharedFonts().getFont((Device)previewText.getDisplay(), result));
                            settingsGroup.layout(true, true);
                        }
                    }
                });
            }
            return dialogArea;
        }

        protected void okPressed() {
            this.newSettings = new ViewSettings();
            this.newSettings.background = this.getBackgroundColor();
            this.newSettings.foreground = this.getForegroundColorPicker();
            this.newSettings.transparency = this.isTransparent();
            this.newSettings.borderWidth = this.getBorderWidth();
            this.newSettings.fontInfo = this.getFontData();
            super.okPressed();
        }

        public boolean isTransparent() {
            return this.transparentCheckbox != null && this.transparentCheckbox.getSelection();
        }

        public Color getBackgroundColor() {
            return this.backgroundColorPicker == null ? null : UIUtils.getSharedTextColors().getColor(this.backgroundColorPicker.getColorValue());
        }

        public Color getForegroundColorPicker() {
            return this.foregroundColorPicker == null ? null : UIUtils.getSharedTextColors().getColor(this.foregroundColorPicker.getColorValue());
        }

        public int getBorderWidth() {
            return this.borderWidthText == null ? 0 : CommonUtils.toInt((Object)this.borderWidthText.getText());
        }

        public String getFontData() {
            return this.fontData;
        }
    }

    private static class ViewSettings {
        private Color background;
        private Color foreground;
        private int borderWidth;
        private boolean transparency;
        private String fontInfo;

        private ViewSettings() {
        }
    }
}

