/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;

public class DataSourceNavigatorSettings
implements DBNBrowseSettings {
    public static final Map<String, Preset> PRESETS = new LinkedHashMap<String, Preset>();
    public static final Preset PRESET_SIMPLE = new Preset("simple", "Simple", "Shows only tables");
    public static final Preset PRESET_FULL = new Preset("advanced", "Advanced", "Shows all database objects");
    public static final Preset PRESET_CUSTOM = new Preset("custom", "Custom", "User configuration");
    private boolean showSystemObjects;
    private boolean showUtilityObjects;
    private boolean showOnlyEntities;
    private boolean mergeEntities;
    private boolean hideFolders;
    private boolean hideSchemas;
    private boolean hideVirtualModel;

    static {
        PRESET_SIMPLE.settings.setShowOnlyEntities(true);
        PRESET_SIMPLE.settings.setHideFolders(true);
        PRESET_SIMPLE.settings.setHideVirtualModel(true);
        PRESET_FULL.settings.setShowSystemObjects(true);
        PRESETS.put(PRESET_SIMPLE.name, PRESET_SIMPLE);
        PRESETS.put(PRESET_FULL.name, PRESET_FULL);
        PRESETS.put(PRESET_CUSTOM.name, PRESET_CUSTOM);
    }

    public DataSourceNavigatorSettings() {
    }

    public DataSourceNavigatorSettings(DBNBrowseSettings copyFrom) {
        this.showSystemObjects = copyFrom.isShowSystemObjects();
        this.showUtilityObjects = copyFrom.isShowUtilityObjects();
        this.showOnlyEntities = copyFrom.isShowOnlyEntities();
        this.mergeEntities = copyFrom.isMergeEntities();
        this.hideFolders = copyFrom.isHideFolders();
        this.hideSchemas = copyFrom.isHideSchemas();
        this.hideVirtualModel = copyFrom.isHideVirtualModel();
    }

    public boolean isShowSystemObjects() {
        return this.showSystemObjects;
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }

    public boolean isShowUtilityObjects() {
        return this.showUtilityObjects;
    }

    public void setShowUtilityObjects(boolean showUtilityObjects) {
        this.showUtilityObjects = showUtilityObjects;
    }

    public boolean isShowOnlyEntities() {
        return this.showOnlyEntities;
    }

    public void setShowOnlyEntities(boolean showOnlyEntities) {
        this.showOnlyEntities = showOnlyEntities;
    }

    public boolean isMergeEntities() {
        return this.mergeEntities;
    }

    public void setMergeEntities(boolean mergeEntities) {
        this.mergeEntities = mergeEntities;
    }

    public boolean isHideFolders() {
        return this.hideFolders;
    }

    public void setHideFolders(boolean hideFolders) {
        this.hideFolders = hideFolders;
    }

    public boolean isHideSchemas() {
        return this.hideSchemas;
    }

    public void setHideSchemas(boolean hideSchemas) {
        this.hideSchemas = hideSchemas;
    }

    public boolean isHideVirtualModel() {
        return this.hideVirtualModel;
    }

    public void setHideVirtualModel(boolean hideVirtualModel) {
        this.hideVirtualModel = hideVirtualModel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataSourceNavigatorSettings)) {
            return false;
        }
        DataSourceNavigatorSettings source = (DataSourceNavigatorSettings)obj;
        return this.showSystemObjects == source.showSystemObjects && this.showUtilityObjects == source.showUtilityObjects && this.showOnlyEntities == source.showOnlyEntities && this.mergeEntities == source.mergeEntities && this.hideFolders == source.hideFolders && this.hideSchemas == source.hideSchemas && this.hideVirtualModel == source.hideVirtualModel;
    }

    public static class Preset {
        private final String id;
        private final String name;
        private final String description;
        private final DataSourceNavigatorSettings settings = new DataSourceNavigatorSettings();

        public Preset(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public DBNBrowseSettings getSettings() {
            return this.settings;
        }
    }
}

