/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.text.parser.TPWordDetector;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.utils.CommonUtils;

class SQLOccurrencesHighlighter {
    protected static final Log log = Log.getLog(SQLOccurrencesHighlighter.class);
    private final SQLEditorBase editor;
    private EditorSelectionChangedListener selectionChangedListener;
    private Annotation[] occurrenceAnnotations = null;
    private boolean markOccurrencesUnderCursor;
    private boolean markOccurrencesForSelection;
    private OccurrencesFinderJob occurrencesFinderJob;
    private OccurrencesFinderJobCanceler occurrencesFinderJobCanceler;
    private final Object LOCK_OBJECT = new Object();

    SQLOccurrencesHighlighter(SQLEditorBase editor) {
        this.editor = editor;
        this.markOccurrencesUnderCursor = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences");
        this.markOccurrencesForSelection = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences.forSelection");
    }

    public boolean isEnabled() {
        return this.markOccurrencesUnderCursor || this.markOccurrencesForSelection;
    }

    private void updateOccurrenceAnnotations(ITextSelection selection) {
        IDocument document;
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
        }
        if ((this.markOccurrencesUnderCursor || this.markOccurrencesForSelection) && selection != null && (document = this.editor.getViewer().getDocument()) != null) {
            TPWordDetector wordDetector = new TPWordDetector();
            int startPos = selection.getOffset();
            int endPos = startPos + selection.getLength();
            try {
                int documentLength = document.getLength();
                while (startPos > 0 && wordDetector.isWordPart(document.getChar(startPos - 1))) {
                    --startPos;
                }
                while (endPos < documentLength && wordDetector.isWordPart(document.getChar(endPos))) {
                    ++endPos;
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error detecting current word: " + e.getMessage()));
            }
            String wordSelected = null;
            String wordUnderCursor = null;
            if (this.markOccurrencesUnderCursor) {
                try {
                    wordUnderCursor = document.get(startPos, endPos - startPos).trim();
                }
                catch (BadLocationException e) {
                    log.debug((Object)"Error detecting word under cursor", (Throwable)e);
                }
            }
            if (this.markOccurrencesForSelection) {
                wordSelected = selection.getText();
                int i = 0;
                while (i < wordSelected.length()) {
                    if (!wordDetector.isWordPart(wordSelected.charAt(i))) {
                        wordSelected = null;
                        break;
                    }
                    ++i;
                }
            }
            if (CommonUtils.isEmpty(wordSelected) || wordSelected.length() < 2) {
                this.removeOccurrenceAnnotations();
            } else {
                OccurrencesFinder finder = new OccurrencesFinder(document, wordUnderCursor, wordSelected);
                List<OccurrencePosition> positions = finder.perform();
                if (!CommonUtils.isEmpty(positions)) {
                    this.occurrencesFinderJob = new OccurrencesFinderJob(positions);
                    this.occurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.removeOccurrenceAnnotations();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel;
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider != null && (annotationModel = documentProvider.getAnnotationModel((Object)this.editor.getEditorInput())) != null && this.occurrenceAnnotations != null) {
            Object object = this.LOCK_OBJECT;
            synchronized (object) {
                this.updateAnnotationModelForRemoves(annotationModel);
            }
        }
    }

    private void updateAnnotationModelForRemoves(IAnnotationModel annotationModel) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.occurrenceAnnotations, null);
        } else {
            int i = 0;
            int length = this.occurrenceAnnotations.length;
            while (i < length) {
                annotationModel.removeAnnotation(this.occurrenceAnnotations[i]);
                ++i;
            }
        }
        this.occurrenceAnnotations = null;
    }

    void installOccurrencesFinder() {
        ISelection selection;
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new EditorSelectionChangedListener();
            this.selectionChangedListener.install(this.editor.getSelectionProvider());
        }
        if (this.editor.getSelectionProvider() != null && (selection = this.editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            this.updateOccurrenceAnnotations((ITextSelection)selection);
        }
        if (this.occurrencesFinderJobCanceler == null) {
            this.occurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.occurrencesFinderJobCanceler.install();
        }
    }

    private void uninstallOccurrencesFinder() {
        this.markOccurrencesUnderCursor = false;
        this.markOccurrencesForSelection = false;
        if (this.occurrencesFinderJob != null) {
            this.occurrencesFinderJob.cancel();
            this.occurrencesFinderJob = null;
        }
        if (this.occurrencesFinderJobCanceler != null) {
            this.occurrencesFinderJobCanceler.uninstall();
            this.occurrencesFinderJobCanceler = null;
        }
        this.removeOccurrenceAnnotations();
    }

    public boolean isMarkingOccurrences() {
        return this.markOccurrencesUnderCursor;
    }

    private void setMarkingOccurrences(boolean markUnderCursor, boolean markSelection) {
        if (markUnderCursor != this.markOccurrencesUnderCursor || markSelection != this.markOccurrencesForSelection) {
            this.markOccurrencesUnderCursor = markUnderCursor;
            this.markOccurrencesForSelection = markSelection;
            if (this.markOccurrencesUnderCursor || this.markOccurrencesForSelection) {
                this.installOccurrencesFinder();
            } else {
                this.uninstallOccurrencesFinder();
            }
        }
    }

    public void dispose() {
        if (this.selectionChangedListener != null) {
            this.selectionChangedListener.uninstall(this.editor.getSelectionProvider());
            this.selectionChangedListener = null;
        }
    }

    void updateInput(IEditorInput input) {
        if (SQLEditorBase.isBigScript(input)) {
            this.uninstallOccurrencesFinder();
        } else {
            this.setMarkingOccurrences(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences"), DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.markOccurrences.forSelection"));
        }
    }

    boolean handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("SQLEditor.markOccurrences".equals(property) || "SQLEditor.markOccurrences.forSelection".equals(property)) {
            this.updateInput(this.editor.getEditorInput());
            return true;
        }
        return false;
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof ITextSelection) {
                SQLOccurrencesHighlighter.this.updateOccurrenceAnnotations((ITextSelection)selection);
            }
        }
    }

    private static class OccurrencePosition
    extends Position {
        boolean forSelection;

        OccurrencePosition(int offset, int length, boolean forSelection) {
            super(offset, length);
            this.forSelection = forSelection;
        }
    }

    private static class OccurrencesFinder {
        private IDocument fDocument;
        private String wordUnderCursor;
        private String wordSelected;

        OccurrencesFinder(IDocument document, String wordUnderCursor, String wordSelected) {
            this.fDocument = document;
            this.wordUnderCursor = wordUnderCursor;
            this.wordSelected = wordSelected;
        }

        public List<OccurrencePosition> perform() {
            if (CommonUtils.isEmpty((String)this.wordUnderCursor) && CommonUtils.isEmpty((String)this.wordSelected)) {
                return null;
            }
            ArrayList<OccurrencePosition> positions = new ArrayList<OccurrencePosition>();
            try {
                if (CommonUtils.equalObjects((Object)this.wordUnderCursor, (Object)this.wordSelected)) {
                    this.findPositions(this.wordUnderCursor, positions, true);
                } else {
                    this.findPositions(this.wordUnderCursor, positions, false);
                    if (!CommonUtils.isEmpty((String)this.wordSelected)) {
                        this.findPositions(this.wordSelected, positions, true);
                    }
                }
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error finding occurrences: " + e.getMessage()));
            }
            return positions;
        }

        private void findPositions(String searchFor, List<OccurrencePosition> positions, boolean forSelection) throws BadLocationException {
            IRegion region;
            FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(this.fDocument);
            int offset = 0;
            while ((region = findReplaceDocumentAdapter.find(offset, searchFor, true, false, !forSelection, false)) != null) {
                positions.add(new OccurrencePosition(region.getOffset(), region.getLength(), forSelection));
                offset = region.getOffset() + region.getLength();
            }
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private boolean isCanceled;
        private IProgressMonitor progressMonitor;
        private List<OccurrencePosition> positions;

        OccurrencesFinderJob(List<OccurrencePosition> positions) {
            super("Occurrences Marker");
            this.isCanceled = false;
            this.positions = positions;
        }

        void doCancel() {
            this.isCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.isCanceled || this.progressMonitor.isCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            IAnnotationModel annotationModel;
            IDocumentProvider documentProvider;
            IDocument document;
            SourceViewer textViewer;
            this.progressMonitor = progressMonitor;
            if (!this.isCanceled() && (textViewer = SQLOccurrencesHighlighter.this.editor.getViewer()) != null && (document = textViewer.getDocument()) != null && (documentProvider = SQLOccurrencesHighlighter.this.editor.getDocumentProvider()) != null && (annotationModel = documentProvider.getAnnotationModel((Object)SQLOccurrencesHighlighter.this.editor.getEditorInput())) != null) {
                LinkedHashMap<Annotation, Position> annotationMap = new LinkedHashMap<Annotation, Position>(this.positions.size());
                for (OccurrencePosition position : this.positions) {
                    if (this.isCanceled()) break;
                    try {
                        String message = document.get(position.offset, position.length);
                        annotationMap.put(new Annotation(position.forSelection ? "org.jkisss.dbeaver.ui.occurrences.forSelection" : "org.jkisss.dbeaver.ui.occurrences.underCursor", false, message), position);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (!this.isCanceled()) {
                    Object object = SQLOccurrencesHighlighter.this.LOCK_OBJECT;
                    synchronized (object) {
                        this.updateAnnotations(annotationModel, annotationMap);
                    }
                    return Status.OK_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }

        private void updateAnnotations(IAnnotationModel annotationModel, Map<Annotation, Position> annotationMap) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(SQLOccurrencesHighlighter.this.occurrenceAnnotations, annotationMap);
            } else {
                SQLOccurrencesHighlighter.this.removeOccurrenceAnnotations();
                for (Map.Entry<Annotation, Position> mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation(mapEntry.getKey(), mapEntry.getValue());
                }
            }
            SQLOccurrencesHighlighter.this.occurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[0]);
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            StyledText text;
            SourceViewer sourceViewer = SQLOccurrencesHighlighter.this.editor.getViewer();
            if (sourceViewer != null && (text = sourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                sourceViewer.addTextInputListener((ITextInputListener)this);
                IDocument document = sourceViewer.getDocument();
                if (document != null) {
                    document.addDocumentListener((IDocumentListener)this);
                }
            }
        }

        void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            SourceViewer sourceViewer = SQLOccurrencesHighlighter.this.editor.getViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = SQLOccurrencesHighlighter.this.editor.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)SQLOccurrencesHighlighter.this.editor.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (SQLOccurrencesHighlighter.this.occurrencesFinderJob != null) {
                SQLOccurrencesHighlighter.this.occurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                oldInput.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                newInput.addDocumentListener((IDocumentListener)this);
            }
        }
    }
}

