/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageResultSetPresentationGrid
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageResultSetPresentationGrid.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.grid";
    private Button gridShowOddRows;
    private Button colorizeDataTypes;
    private Button gridShowAttrIcons;
    private Button gridShowAttrFilters;
    private Button gridShowAttrOrder;
    private Button useSmoothScrolling;
    private Button showBooleanAsCheckbox;
    private Combo gridDoubleClickBehavior;
    private Text gridRowBatchSize;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.show.oddRows") || store.contains("resultset.show.colorizeDataTypes") || store.contains("resultset.show.attIcons") || store.contains("resultset.show.attFilters") || store.contains("resultset.show.attOrdering") || store.contains("resultset.hScroll.smooth") || store.contains("resultset.show.boolean.checkbox") || store.contains("resultset.behavior.doubleClick") || store.contains("resultset.show.row.batch.size");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group uiGroup = UIUtils.createControlGroup((Composite)composite, (String)DataEditorsMessages.pref_page_database_resultsets_group_grid, (int)2, (int)2, (int)0);
        this.gridShowOddRows = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_mark_odd_rows, null, (boolean)false, (int)2);
        this.colorizeDataTypes = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_colorize_data_types, null, (boolean)false, (int)2);
        this.gridShowAttrIcons = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_icons, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_icons_tip, (boolean)false, (int)2);
        this.gridShowAttrFilters = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_filters, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_filters_tip, (boolean)false, (int)2);
        this.gridShowAttrOrder = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_ordering, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_ordering_tip, (boolean)false, (int)2);
        this.useSmoothScrolling = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_use_smooth_scrolling, (String)DataEditorsMessages.pref_page_database_resultsets_label_use_smooth_scrolling_tip, (boolean)false, (int)2);
        this.showBooleanAsCheckbox = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_boolean_as_checkbox, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_boolean_as_checkbox_tip, (boolean)false, (int)2);
        this.gridDoubleClickBehavior = UIUtils.createLabelCombo((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_double_click_behavior, (int)8);
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_none, Spreadsheet.DoubleClickBehavior.NONE.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_editor, Spreadsheet.DoubleClickBehavior.EDITOR.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_inline_editor, Spreadsheet.DoubleClickBehavior.INLINE_EDITOR.ordinal());
        this.gridRowBatchSize = UIUtils.createLabelText((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_row_batch_size, (String)"", (int)2048);
        this.gridRowBatchSize.setToolTipText(DataEditorsMessages.pref_page_database_resultsets_label_row_batch_size_tip);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.gridShowOddRows.setSelection(store.getBoolean("resultset.show.oddRows"));
            this.colorizeDataTypes.setSelection(store.getBoolean("resultset.show.colorizeDataTypes"));
            this.gridShowAttrIcons.setSelection(store.getBoolean("resultset.show.attIcons"));
            this.gridShowAttrFilters.setSelection(store.getBoolean("resultset.show.attFilters"));
            this.gridShowAttrOrder.setSelection(store.getBoolean("resultset.show.attOrdering"));
            this.useSmoothScrolling.setSelection(store.getBoolean("resultset.hScroll.smooth"));
            this.showBooleanAsCheckbox.setSelection(store.getBoolean("resultset.show.boolean.checkbox"));
            this.gridDoubleClickBehavior.select(((Spreadsheet.DoubleClickBehavior)CommonUtils.valueOf(Spreadsheet.DoubleClickBehavior.class, (String)store.getString("resultset.behavior.doubleClick"), (Enum)Spreadsheet.DoubleClickBehavior.NONE)).ordinal());
            this.gridRowBatchSize.setText(store.getString("resultset.show.row.batch.size"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.show.oddRows", this.gridShowOddRows.getSelection());
            store.setValue("resultset.show.colorizeDataTypes", this.colorizeDataTypes.getSelection());
            store.setValue("resultset.show.attIcons", this.gridShowAttrIcons.getSelection());
            store.setValue("resultset.show.attFilters", this.gridShowAttrFilters.getSelection());
            store.setValue("resultset.show.attOrdering", this.gridShowAttrOrder.getSelection());
            store.setValue("resultset.hScroll.smooth", this.useSmoothScrolling.getSelection());
            store.setValue("resultset.show.boolean.checkbox", this.showBooleanAsCheckbox.getSelection());
            store.setValue("resultset.behavior.doubleClick", ((Spreadsheet.DoubleClickBehavior)CommonUtils.fromOrdinal(Spreadsheet.DoubleClickBehavior.class, (int)this.gridDoubleClickBehavior.getSelectionIndex())).name());
            store.setValue("resultset.show.row.batch.size", CommonUtils.toInt((Object)this.gridRowBatchSize.getText()));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.show.oddRows");
        store.setToDefault("resultset.show.colorizeDataTypes");
        store.setToDefault("resultset.show.attIcons");
        store.setToDefault("resultset.show.attFilters");
        store.setToDefault("resultset.show.attOrdering");
        store.setToDefault("resultset.hScroll.smooth");
        store.setToDefault("resultset.show.boolean.checkbox");
        store.setToDefault("resultset.behavior.doubleClick");
        store.setToDefault("resultset.show.row.batch.size");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

