/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.DataSourceBindingDescriptor;

public class DataSourceAuthModelDescriptor
extends DataSourceBindingDescriptor
implements DBPAuthModelDescriptor {
    private static final Log log = Log.getLog(DataSourceAuthModelDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceAuth";
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private DBPImage icon;
    private List<String> replaces = new ArrayList<String>();
    private DBAAuthModel instance;

    public DataSourceAuthModelDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = DBIcon.TREE_PACKAGE;
        }
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("replace");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsConfig = iConfigurationElementArray[n2];
            this.replaces.add(dsConfig.getAttribute("model"));
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getImplClassName() {
        return this.implType.getImplName();
    }

    public boolean isApplicableTo(DBPDriver driver) {
        return this.appliesTo(driver);
    }

    @NotNull
    public DBAAuthModel getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (DBAAuthModel)this.implType.createInstance(DBAAuthModel.class);
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source auth model '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    boolean appliesTo(DBPDriver driver) {
        return this.isDriverApplicable(driver);
    }

    public List<String> getReplaces() {
        return this.replaces;
    }

    public String toString() {
        return this.id;
    }
}

