/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SQLServerTable
extends SQLServerTableBase
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(SQLServerTable.class);
    private CheckConstraintCache checkConstraintCache = new CheckConstraintCache();
    private volatile transient List<SQLServerTableForeignKey> references;
    private volatile transient long totalBytes = -1L;
    private volatile transient long usedBytes = -1L;

    public SQLServerTable(SQLServerSchema schema) {
        super(schema);
    }

    public SQLServerTable(DBRProgressMonitor monitor, SQLServerSchema schema, SQLServerTable source) throws DBException {
        super(monitor, schema, source);
        DBSObjectCache colCache = ((SQLServerSchema)this.getContainer()).getTableCache().getChildrenCache(this);
        for (DBSEntityAttribute srcColumn : CommonUtils.safeCollection(source.getAttributes(monitor))) {
            if (DBUtils.isHiddenObject((Object)srcColumn)) continue;
            SQLServerTableColumn column = new SQLServerTableColumn(monitor, (SQLServerTableBase)this, srcColumn);
            colCache.cacheObject((DBSObject)column);
        }
    }

    public SQLServerTable(SQLServerSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    public boolean isView() {
        return false;
    }

    @Override
    @Property(category="Statistics", viewable=false, expensive=true, order=30)
    public Long getRowCount(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return super.getRowCount(monitor);
    }

    @Property(viewable=true, category="Statistics", order=31)
    public long getTotalBytes(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return this.totalBytes;
    }

    @Property(viewable=true, category="Statistics", order=32)
    public long getUsedBytes(DBRProgressMonitor monitor) throws DBCException {
        this.readTableStats(monitor);
        return this.usedBytes;
    }

    @Nullable
    @Association
    public Collection<SQLServerTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().getObjects(monitor, this.getSchema(), this);
    }

    @Nullable
    @Association
    public synchronized Collection<SQLServerTableCheckConstraint> getCheckConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.checkConstraintCache.getAllObjects(monitor, this);
    }

    public CheckConstraintCache getCheckConstraintCache() {
        return this.checkConstraintCache;
    }

    /*
     * Exception decompiling
     */
    @Association
    public List<SQLServerTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection<SQLServerTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getForeignKeyCache().getObjects(monitor, this.getSchema(), this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
    }

    public boolean supportsObjectDefinitionOption(String option) {
        return "ddl.onlyForeignKeys".equals(option) || "ddl.skipForeignKeys".equals(option);
    }

    @Nullable
    @Association
    public List<SQLServerTableTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        List allTriggers = this.getSchema().getTriggerCache().getAllObjects(monitor, this.getSchema());
        return allTriggers.stream().filter(p -> p.getTable() == this).collect(Collectors.toList());
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.references = null;
        this.totalBytes = -1L;
        this.usedBytes = -1L;
        ((SQLServerSchema)this.getContainer()).getIndexCache().clearObjectCache(this);
        ((SQLServerSchema)this.getContainer()).getUniqueConstraintCache().clearObjectCache(this);
        ((SQLServerSchema)this.getContainer()).getForeignKeyCache().clearObjectCache(this);
        ((SQLServerSchema)this.getContainer()).getTriggerCache().clearChildrenOf(this);
        return super.refreshObject(monitor);
    }

    public void setObjectDefinitionText(String source) {
    }

    public boolean hasStatistics() {
        return this.totalBytes != -1L;
    }

    public long getStatObjectSize() {
        return this.totalBytes;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readTableStats(DBRProgressMonitor monitor) throws DBCException {
        if (this.hasStatistics()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table statistics");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT t.name, p.rows, SUM(a.total_pages) * 8 AS totalSize, SUM(a.used_pages) * 8 AS usedSize\nFROM " + SQLServerUtils.getSystemTableName(this.getDatabase(), "tables") + " t\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "indexes") + " i ON t.OBJECT_ID = i.object_id\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "partitions") + " p ON i.object_id = p.OBJECT_ID AND i.index_id = p.index_id\n" + "INNER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "allocation_units") + " a ON p.partition_id = a.container_id\n" + "LEFT OUTER JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "schemas") + " s ON t.schema_id = s.schema_id\n" + "WHERE t.schema_id = ?\n AND t.object_id=?\n" + "GROUP BY t.name, p.rows");){
                    dbStat.setLong(1, this.getSchema().getObjectId());
                    dbStat.setLong(2, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchTableStats(dbResult);
                        } else {
                            this.setDefaultTableStats();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading table statistics", (Throwable)e);
        }
    }

    void fetchTableStats(JDBCResultSet dbResult) throws SQLException {
        this.rowCount = dbResult.getLong("rows");
        this.totalBytes = dbResult.getLong("totalSize") * 1024L;
        this.usedBytes = dbResult.getLong("usedSize") * 1024L;
    }

    void setDefaultTableStats() {
        this.totalBytes = 0L;
        this.usedBytes = 0L;
    }

    static class CheckConstraintCache
    extends JDBCObjectCache<SQLServerTable, SQLServerTableCheckConstraint> {
        CheckConstraintCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerTable table) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + SQLServerUtils.getSystemTableName(table.getDatabase(), "check_constraints") + " WHERE parent_object_id=?");
            dbStat.setLong(1, table.getObjectId());
            return dbStat;
        }

        protected SQLServerTableCheckConstraint fetchObject(@NotNull JDBCSession session, @NotNull SQLServerTable table, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerTableCheckConstraint(table, resultSet);
        }
    }
}

