/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;

class SQLToolTaskObjectSelectorDialog
extends BaseDialog {
    private DBNProject projectNode;
    private TaskTypeDescriptor taskType;
    private DatabaseNavigatorTree dataSourceTree;
    private List<DBSObject> selectedObjects = new ArrayList<DBSObject>();

    SQLToolTaskObjectSelectorDialog(Shell parentShell, DBNProject projectNode, TaskTypeDescriptor taskType) {
        super(parentShell, "Select input objects", null);
        this.projectNode = projectNode;
        this.taskType = taskType;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        INavigatorFilter dsFilter = new INavigatorFilter(){

            public boolean filterFolders() {
                return true;
            }

            public boolean isLeafObject(Object object) {
                return object instanceof DBNDatabaseItem && SQLToolTaskObjectSelectorDialog.this.taskType.appliesTo((DBPObject)((DBNDatabaseItem)object).getObject());
            }

            public boolean select(Object element) {
                if (element instanceof DBNProject || element instanceof DBNProjectDatabases) {
                    return true;
                }
                if (element instanceof DBNLocalFolder) {
                    for (DBNDataSource ds : ((DBNLocalFolder)element).getNestedDataSources()) {
                        if (!SQLToolTaskObjectSelectorDialog.this.taskType.isDriverApplicable(ds.getDataSourceContainer().getDriver())) continue;
                        return true;
                    }
                    return false;
                }
                if (element instanceof DBNDataSource) {
                    return SQLToolTaskObjectSelectorDialog.this.taskType.isDriverApplicable(((DBNDataSource)element).getDataSourceContainer().getDriver());
                }
                if (element instanceof DBNDatabaseItem) {
                    return DBSObjectContainer.class.isAssignableFrom(((DBNDatabaseItem)element).getObject().getClass()) || SQLToolTaskObjectSelectorDialog.this.taskType.appliesTo((DBPObject)((DBNDatabaseItem)element).getObject());
                }
                if (element instanceof DBNDatabaseFolder) {
                    Class childrenClass = ((DBNDatabaseFolder)element).getChildrenClass();
                    return childrenClass != null && (DBSObjectContainer.class.isAssignableFrom(childrenClass) || SQLToolTaskObjectSelectorDialog.this.taskType.matchesType(childrenClass));
                }
                return false;
            }
        };
        this.dataSourceTree = new DatabaseNavigatorTree(dialogArea, (DBNNode)this.projectNode.getDatabases(), 2084, false, dsFilter);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.dataSourceTree.setLayoutData((Object)gd);
        this.dataSourceTree.getViewer().addSelectionChangedListener(event -> this.updateSelectedObjects());
        return dialogArea;
    }

    private void updateSelectedObjects() {
        this.selectedObjects.clear();
        Object[] objectArray = this.dataSourceTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNDatabaseItem && this.taskType.matchesType(((DBNDatabaseItem)element).getObject().getClass())) {
                this.selectedObjects.add(((DBNDatabaseItem)element).getObject());
            }
            ++n2;
        }
        this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
    }

    public List<DBSObject> getSelectedObjects() {
        return this.selectedObjects;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

