/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.utils.CommonUtils;

public class SQLDialectDescriptor
extends AbstractContextDescriptor
implements SQLDialectMetadata {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlDialect";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private boolean isAbstract;
    private boolean isHidden;
    private SQLDialectDescriptor parentDialect;
    private List<SQLDialectDescriptor> subDialects = null;
    private Map<String, Object> properties;
    private List<String> keywords;
    private List<String> ddlKeywords;
    private List<String> dmlKeywords;
    private List<String> execKeywords;
    private List<String> txnKeywords;
    private List<String> types;
    private List<String> functions;

    SQLDialectDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.isAbstract = CommonUtils.getBoolean((String)config.getAttribute("abstract"));
        this.isHidden = CommonUtils.getBoolean((String)config.getAttribute("hidden"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("property");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block27: {
                IConfigurationElement propElement = iConfigurationElementArray[n2];
                String propName = propElement.getAttribute("name");
                String propValue = propElement.getAttribute("value");
                if (propName == null || CommonUtils.isEmpty((String)propValue)) break block27;
                switch (propName) {
                    case "keywords": {
                        this.keywords = this.loadList(propValue);
                        break;
                    }
                    case "ddlKeywords": {
                        this.ddlKeywords = this.loadList(propValue);
                        break;
                    }
                    case "dmlKeywords": {
                        this.dmlKeywords = this.loadList(propValue);
                        break;
                    }
                    case "execKeywords": {
                        this.execKeywords = this.loadList(propValue);
                        break;
                    }
                    case "txnKeywords": {
                        this.txnKeywords = this.loadList(propValue);
                        break;
                    }
                    case "types": {
                        this.types = this.loadList(propValue);
                        break;
                    }
                    case "functions": {
                        this.functions = this.loadList(propValue);
                        break;
                    }
                    default: {
                        if (this.properties == null) {
                            this.properties = new LinkedHashMap<String, Object>();
                        }
                        this.properties.put(propName, propValue);
                    }
                }
            }
            ++n2;
        }
    }

    private List<String> loadList(String str) {
        List<String> list = Arrays.asList(str.split(","));
        int i = 0;
        while (i < list.size()) {
            list.set(i, list.get(i).toUpperCase(Locale.ENGLISH));
            ++i;
        }
        return list;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    @NotNull
    public SQLDialect createInstance() throws DBException {
        return (SQLDialect)this.implClass.createInstance(SQLDialect.class);
    }

    @NotNull
    public List<String> getReservedWords() {
        return CommonUtils.safeList(this.keywords);
    }

    @NotNull
    public List<String> getDataTypes() {
        return CommonUtils.safeList(this.types);
    }

    @NotNull
    public List<String> getFunctions() {
        return CommonUtils.safeList(this.functions);
    }

    @NotNull
    public List<String> getDDLKeywords() {
        return CommonUtils.safeList(this.ddlKeywords);
    }

    @NotNull
    public List<String> getDMLKeywords() {
        return CommonUtils.safeList(this.dmlKeywords);
    }

    @NotNull
    public List<String> getExecuteKeywords() {
        return CommonUtils.safeList(this.execKeywords);
    }

    @NotNull
    public List<String> getTransactionKeywords() {
        return CommonUtils.safeList(this.txnKeywords);
    }

    @NotNull
    public String getScriptDelimiter() {
        return ";";
    }

    public Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    @Nullable
    public SQLDialectMetadata getParentDialect() {
        return this.parentDialect;
    }

    void setParentDialect(SQLDialectDescriptor parentDialect) {
        this.parentDialect = parentDialect;
        List<SQLDialectDescriptor> psd = parentDialect.subDialects;
        if (psd == null) {
            parentDialect.subDialects = psd = new ArrayList<SQLDialectDescriptor>();
        }
        psd.add(this);
    }

    @NotNull
    public List<SQLDialectMetadata> getSubDialects(boolean addNested) {
        if (this.subDialects == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLDialectMetadata> subs = new ArrayList<SQLDialectMetadata>();
        for (SQLDialectDescriptor sd : this.subDialects) {
            if (sd.isHidden) {
                subs.addAll(sd.getSubDialects(false));
                continue;
            }
            subs.add(sd);
        }
        return subs;
    }

    public String toString() {
        return String.valueOf(this.label) + " (" + this.id + ")";
    }
}

