/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.encode.SecuredPasswordEncrypter;
import org.jkiss.dbeaver.tasks.nativetool.AbstractToolSettings;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractNativeToolSettings<BASE_OBJECT extends DBSObject>
extends AbstractToolSettings<BASE_OBJECT> {
    private static final Log log = Log.getLog(AbstractNativeToolSettings.class);
    private final String PROP_NAME_EXTRA_ARGS = "tools.wizard." + this.getClass().getSimpleName() + ".extraArgs";
    private DBPNativeClientLocation clientHome;
    private Writer logWriter = new PrintWriter(System.out, true);
    private String clientHomeName;
    private String toolUserName;
    private String toolUserPassword;
    private String extraCommandArgs;

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return null;
    }

    public Writer getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(Writer logWriter) {
        this.logWriter = logWriter;
    }

    public String getClientHomeName() {
        return this.clientHomeName;
    }

    public DBPNativeClientLocation getClientHome() {
        return this.clientHome;
    }

    public void setClientHome(DBPNativeClientLocation clientHome) {
        this.clientHome = clientHome;
        this.clientHomeName = clientHome == null ? null : clientHome.getName();
    }

    public String getToolUserName() {
        return this.toolUserName;
    }

    public void setToolUserName(String toolUserName) {
        this.toolUserName = toolUserName;
    }

    public String getToolUserPassword() {
        return this.toolUserPassword;
    }

    public void setToolUserPassword(String toolUserPassword) {
        this.toolUserPassword = toolUserPassword;
    }

    public String getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(String extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    public void addExtraCommandArgs(List<String> cmd) {
        if (!CommonUtils.isEmptyTrimmed((String)this.extraCommandArgs)) {
            Collections.addAll(cmd, this.extraCommandArgs.split(" "));
        }
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) throws DBException {
        super.loadSettings(runnableContext, preferenceStore);
        this.extraCommandArgs = preferenceStore.getString(this.PROP_NAME_EXTRA_ARGS);
        this.clientHomeName = preferenceStore.getString("clientHomeName");
        this.toolUserName = preferenceStore.getString("tool.user");
        this.toolUserPassword = preferenceStore.getString("tool.password");
        try {
            SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
            if (!CommonUtils.isEmpty((String)this.toolUserName)) {
                this.toolUserName = encrypter.decrypt(this.toolUserName);
            }
            if (!CommonUtils.isEmpty((String)this.toolUserPassword)) {
                this.toolUserPassword = encrypter.decrypt(this.toolUserPassword);
            }
        }
        catch (Exception e) {
            throw new DBException("Error decrypting user credentials", (Throwable)e);
        }
    }

    @Override
    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        super.saveSettings(runnableContext, preferenceStore);
        preferenceStore.setValue(this.PROP_NAME_EXTRA_ARGS, this.extraCommandArgs);
        if (this.clientHomeName != null) {
            preferenceStore.setValue("clientHomeName", this.clientHomeName);
        }
        try {
            SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
            if (!CommonUtils.isEmpty((String)this.toolUserName)) {
                preferenceStore.setValue("tool.user", encrypter.encrypt(this.toolUserName));
            } else {
                preferenceStore.setToDefault("tool.user");
            }
            if (!CommonUtils.isEmpty((String)this.toolUserPassword)) {
                preferenceStore.setValue("tool.password", encrypter.encrypt(this.toolUserPassword));
            } else {
                preferenceStore.setToDefault("tool.password");
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }
}

