/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class SSLConfiguratorTrustStoreUI
extends SSLConfiguratorAbstractUI {
    private TextWithOpen caCertPath;
    private TextWithOpen clientCertPath;
    private TextWithOpen clientKeyPath;

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createTrustStoreConfigGroup(composite);
    }

    protected Composite createTrustStoreConfigGroup(Composite composite) {
        GridData gd;
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Client Certificate", (int)2, (int)768, (int)-1);
        if (this.useCACertificate()) {
            UIUtils.createControlLabel((Composite)certGroup, (String)"CA Certificate");
            gd = new GridData(768);
            gd.minimumWidth = 130;
            this.caCertPath = new TextWithOpenFile((Composite)certGroup, "CA Certificate", new String[]{"*.*", "*.crt", "*"});
            this.caCertPath.setLayoutData((Object)new GridData(768));
        }
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Certificate");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCertPath = new TextWithOpenFile((Composite)certGroup, "Client Certificate", new String[]{"*.*", "*.crt", "*"});
        this.clientCertPath.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)"Client Private Key");
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientKeyPath = new TextWithOpenFile((Composite)certGroup, "Client Key", new String[]{"*.*", "*.key", "*"});
        this.clientKeyPath.setLayoutData((Object)new GridData(768));
        return certGroup;
    }

    protected boolean useCACertificate() {
        return false;
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        if (this.caCertPath != null) {
            this.caCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.ca.cert")));
        }
        this.clientCertPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.cert")));
        this.clientKeyPath.setText(CommonUtils.notEmpty((String)configuration.getStringProperty("ssl.client.key")));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        if (this.caCertPath != null) {
            configuration.setProperty("ssl.ca.cert", (Object)this.caCertPath.getText());
        }
        configuration.setProperty("ssl.client.cert", (Object)this.clientCertPath.getText());
        configuration.setProperty("ssl.client.key", (Object)this.clientKeyPath.getText());
    }
}

