/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.athena;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.athena.model.AthenaDataSource;
import org.jkiss.dbeaver.ext.athena.model.AthenaMetaModel;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AthenaDataSourceProvider
extends GenericDataSourceProvider {
    private static final Log log = Log.getLog(AthenaDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new AthenaDataSource(monitor, container, new AthenaMetaModel());
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String urlTemplate = driver.getSampleURL();
        if (CommonUtils.isEmpty((String)urlTemplate) || !urlTemplate.startsWith("jdbc:awsathena://")) {
            return "jdbc:awsathena://AwsRegion=" + connectionInfo.getServerName() + ";";
        }
        urlTemplate = urlTemplate.replace("{region}", connectionInfo.getServerName()).replace("=region;", "=" + connectionInfo.getServerName() + ";");
        return urlTemplate;
    }
}

