/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class PostgreRefCursor
implements DBDCursor {
    private static final Log log = Log.getLog(PostgreRefCursor.class);
    private String cursorName;
    private JDBCPreparedStatement cursorStatement;

    public PostgreRefCursor(@NotNull String cursorName) throws SQLException {
        this.cursorName = cursorName;
    }

    public Object getRawValue() {
        return this.cursorName;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        if (this.cursorStatement != null) {
            this.cursorStatement.close();
            this.cursorStatement = null;
        }
    }

    public DBCResultSet openResultSet(DBCSession session) throws DBCException {
        this.release();
        try {
            this.cursorStatement = ((JDBCSession)session).prepareStatement("FETCH ALL IN \"" + this.cursorName + "\"");
            return this.cursorStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Nullable
    public String getCursorName() {
        return this.cursorName;
    }

    public String toString() {
        return this.cursorName;
    }
}

