/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class PostgreGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final PostgreGeometryValueHandler INSTANCE = new PostgreGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            Object object = resultSet.getObject(index);
            return this.getValueFromObject(session, type, object, false, false);
        }
        catch (SQLException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                String wkbValue = resultSet.getString(index);
                return WKGUtils.parseWKB((String)wkbValue);
            }
            throw e;
        }
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        int valueSRID = 0;
        if (value instanceof DBGeometry) {
            valueSRID = ((DBGeometry)value).getSRID();
            value = ((DBGeometry)value).getRawValue();
        }
        if (valueSRID == 0 && paramType instanceof GisAttribute) {
            valueSRID = ((GisAttribute)paramType).getAttributeGeometrySRID(session.getProgressMonitor());
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Geometry) {
            if (((Geometry)value).getSRID() == 0) {
                ((Geometry)value).setSRID(valueSRID);
            }
            statement.setObject(paramIndex, (Object)this.getStringFromGeometry(session, (Geometry)value), 1111);
        } else if (value.getClass().getName().equals("org.postgis.PGgeometry")) {
            statement.setObject(paramIndex, value, 1111);
        } else {
            String strValue = value.toString();
            if (valueSRID != 0 && !strValue.startsWith("SRID=")) {
                strValue = "SRID=" + valueSRID + ";" + strValue;
            }
            statement.setObject(paramIndex, (Object)strValue, 1111);
        }
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new DBGeometry();
        }
        if (object instanceof DBGeometry) {
            if (copy) {
                return ((DBGeometry)object).copy();
            }
            return object;
        }
        if (object instanceof Geometry) {
            return new DBGeometry((Geometry)object);
        }
        if (object instanceof String) {
            return this.makeGeometryFromWKT(session, (String)object, 2);
        }
        if (object.getClass().getName().equals("org.postgis.PGgeometry")) {
            return this.makeGeometryFromPGGeometry(session, object);
        }
        if (object.getClass().getName().equals("org.postgresql.util.PGobject")) {
            return this.makeGeometryFromWKB(session, CommonUtils.toString((Object)PostgreUtils.extractPGObjectValue(object)));
        }
        return this.makeGeometryFromWKT(session, object.toString(), 2);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBGeometry && format == DBDDisplayFormat.NATIVE) {
            return "'" + value.toString() + "'";
        }
        return super.getValueDisplayString(column, value, format);
    }

    private DBGeometry makeGeometryFromWKB(DBCSession session, String hexString) throws DBCException {
        byte[] binaryData = WKBReader.hexToBytes((String)hexString);
        try {
            Geometry geometry = new WKBReader().read(binaryData);
            return new DBGeometry(geometry);
        }
        catch (Exception e) {
            throw new DBCException("Error parsing WKB value", (Throwable)e);
        }
    }

    private DBGeometry makeGeometryFromPGGeometry(DBCSession session, Object value) throws DBCException {
        try {
            Object dimension;
            Object geometry = BeanUtils.invokeObjectMethod((Object)value, (String)"getGeometry");
            if (geometry != null && (dimension = BeanUtils.invokeObjectMethod((Object)geometry, (String)"getDimension")) instanceof Number) {
                return this.makeGeometryFromWKT(session, geometry.toString(), ((Number)dimension).intValue());
            }
            String pgString = value.toString();
            return this.makeGeometryFromWKT(session, pgString, 2);
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    private DBGeometry makeGeometryFromWKT(DBCSession session, String pgString, int dimensions) throws DBCException {
        if (CommonUtils.isEmpty((String)pgString)) {
            return new DBGeometry();
        }
        try {
            int divPos = pgString.indexOf(59);
            if (divPos == -1) {
                if (dimensions == 2) {
                    try {
                        Geometry geometry = new WKTReader().read(pgString);
                        return new DBGeometry(geometry);
                    }
                    catch (ParseException parseException) {
                        return new DBGeometry(pgString);
                    }
                }
                return new DBGeometry(pgString);
            }
            String sridString = pgString.substring(0, divPos);
            String wktString = pgString.substring(divPos + 1);
            int srid = 0;
            if (sridString.startsWith("SRID=")) {
                srid = CommonUtils.toInt((Object)sridString.substring(5));
            }
            if (dimensions == 2) {
                Geometry geometry = new WKTReader().read(wktString);
                if (srid > 0) {
                    geometry.setSRID(srid);
                }
                return new DBGeometry(geometry);
            }
            return new DBGeometry((Object)wktString, srid);
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getExecutionContext());
        }
    }

    private String getStringFromGeometry(JDBCSession session, Geometry geometry) throws DBCException {
        String strGeom = geometry.toString();
        if (geometry.getSRID() > 0) {
            return "SRID=" + geometry.getSRID() + ";" + strGeom;
        }
        return strGeom;
    }
}

