/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndexColumn;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolTableIndexCache
extends JDBCCompositeCache<ExasolSchema, ExasolTable, ExasolTableIndex, ExasolTableIndexColumn> {
    private static final String QUERYINDEX = "SELECT * FROM SYS.%s_INDICES WHERE INDEX_SCHEMA = '%s'";
    private static final Pattern indexCols = Pattern.compile(".+\\((.+)\\)");

    public ExasolTableIndexCache(ExasolTableCache parentCache) {
        super((JDBCStructCache)parentCache, ExasolTable.class, (Object)"INDEX_TABLE", (Object)"REMARKS");
    }

    protected JDBCStatement prepareObjectsStatement(JDBCSession session, ExasolSchema schema, ExasolTable table) throws SQLException {
        String tablePrefix = ((ExasolDataSource)table.getDataSource()).getTablePrefix(ExasolSysTablePrefix.ALL);
        StringBuilder sql = new StringBuilder(String.format(QUERYINDEX, tablePrefix, ExasolUtils.quoteString(schema.getName())));
        if (table != null) {
            sql.append(String.format(" AND INDEX_TABLE = '%s'", ExasolUtils.quoteString(table.getName())));
        }
        JDBCStatement dbstat = session.createStatement();
        dbstat.setQueryString(sql.toString());
        return dbstat;
    }

    protected ExasolTableIndex fetchObject(JDBCSession session, ExasolSchema schema, ExasolTable table, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolTableIndex(session.getProgressMonitor(), table, indexName, (ResultSet)dbResult);
    }

    protected ExasolTableIndexColumn[] fetchObjectRow(JDBCSession session, ExasolTable parent, ExasolTableIndex forObject, JDBCResultSet resultSet) throws SQLException, DBException {
        Matcher m = indexCols.matcher(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMARKS"));
        ArrayList<ExasolTableIndexColumn> indexCols = new ArrayList<ExasolTableIndexColumn>();
        if (m.find()) {
            String[] colString = m.group(1).split(",");
            int i = 0;
            while (i < colString.length) {
                ExasolTableColumn tableColumn = colString[i] == null ? null : parent.getAttribute(session.getProgressMonitor(), colString[i]);
                indexCols.add(new ExasolTableIndexColumn(forObject, tableColumn, i + 1));
                ++i;
            }
        }
        ExasolTableIndexColumn[] arrayIndexCols = new ExasolTableIndexColumn[indexCols.size()];
        arrayIndexCols = indexCols.toArray(arrayIndexCols);
        return arrayIndexCols;
    }

    protected void cacheChildren(DBRProgressMonitor monitor, ExasolTableIndex index, List<ExasolTableIndexColumn> cols) {
        index.setColumns(cols);
    }
}

