/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.utils.CommonUtils;

public class ProgressLoaderVisualizer<RESULT>
implements ILoadVisualizer<RESULT> {
    private static final Log log = Log.getLog(ProgressLoaderVisualizer.class);
    protected static final int PROGRESS_VISUALIZE_PERIOD = 100;
    static final DBIcon[] PROGRESS_IMAGES = new DBIcon[]{UIIcon.PROGRESS0, UIIcon.PROGRESS1, UIIcon.PROGRESS2, UIIcon.PROGRESS3, UIIcon.PROGRESS4, UIIcon.PROGRESS5, UIIcon.PROGRESS6, UIIcon.PROGRESS7, UIIcon.PROGRESS8, UIIcon.PROGRESS9};
    private final ILoadService<RESULT> loadService;
    private final Composite progressPane;
    private volatile boolean finished = false;
    private ControlEditor progressOverlay;
    private volatile int drawCount = 0;
    private Button cancelButton;
    private PaintListener painListener;
    private Color shadowColor;
    private String progressMessage;
    private long loadStartTime;

    public ProgressLoaderVisualizer(ILoadService<RESULT> loadService, Composite progressPane) {
        this.loadService = loadService;
        this.progressPane = progressPane;
        this.progressMessage = "Initializing";
    }

    public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
        ProxyProgressMonitor progressMonitor = new ProxyProgressMonitor(monitor){

            public void subTask(String name) {
                if (ProgressLoaderVisualizer.this.loadStartTime == 0L) {
                    ProgressLoaderVisualizer.this.resetStartTime();
                }
                ProgressLoaderVisualizer.this.progressMessage = name;
                super.subTask(name);
            }
        };
        return progressMonitor;
    }

    public void resetStartTime() {
        this.loadStartTime = System.currentTimeMillis();
    }

    public boolean isCompleted() {
        return this.finished;
    }

    public void completeLoading(RESULT result) {
        this.finished = true;
    }

    public void visualizeLoading() {
        if (!this.progressPane.isDisposed()) {
            if (this.shadowColor == null) {
                this.shadowColor = this.progressPane.getDisplay().getSystemColor(18);
            }
            if (!this.finished) {
                try {
                    this.showProgress();
                }
                catch (Exception e) {
                    log.error((Object)"Internal error during progress visualization", (Throwable)e);
                    this.finishProgress();
                }
            }
            if (this.finished) {
                this.finishProgress();
            }
        }
    }

    private void showProgress() {
        if (this.loadStartTime == 0L) {
            return;
        }
        if (this.progressOverlay == null) {
            this.cancelButton = new Button(this.progressPane, 8);
            this.cancelButton.setText("Cancel");
            GridData gd = new GridData(1808);
            gd.verticalIndent = DBeaverIcons.getImage((DBPImage)UIIcon.PROGRESS0).getBounds().height * 2;
            this.cancelButton.setLayoutData((Object)gd);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProgressLoaderVisualizer.this.cancelButton.setText("Canceled");
                    ProgressLoaderVisualizer.this.cancelButton.setEnabled(false);
                    Point buttonSize = ProgressLoaderVisualizer.this.cancelButton.computeSize(-1, -1);
                    ((ProgressLoaderVisualizer)ProgressLoaderVisualizer.this).progressOverlay.minimumWidth = buttonSize.x;
                    ((ProgressLoaderVisualizer)ProgressLoaderVisualizer.this).progressOverlay.minimumHeight = buttonSize.y;
                    ProgressLoaderVisualizer.this.progressOverlay.layout();
                    try {
                        ProgressLoaderVisualizer.this.loadService.cancel();
                    }
                    catch (InvocationTargetException e1) {
                        log.error((Object)e1.getTargetException());
                    }
                }
            });
            this.painListener = e -> {
                if (this.cancelButton.isDisposed()) {
                    return;
                }
                Image image = DBeaverIcons.getImage((DBPImage)PROGRESS_IMAGES[this.drawCount % PROGRESS_IMAGES.length]);
                Rectangle buttonBounds = this.cancelButton.getBounds();
                Rectangle imageBounds = image.getBounds();
                e.gc.drawImage(image, buttonBounds.x + buttonBounds.width / 2 - imageBounds.width / 2, buttonBounds.y - imageBounds.height - 5);
                long elapsedTime = System.currentTimeMillis() - this.loadStartTime;
                String elapsedString = elapsedTime > 10000L ? String.valueOf(elapsedTime / 1000L) : String.valueOf((double)(elapsedTime / 100L) / 10.0);
                String statusMessage = CommonUtils.truncateString((String)this.progressMessage.replaceAll("\\s", " "), (int)64);
                String status = String.valueOf(statusMessage) + " - " + elapsedString + "s";
                Point statusSize = e.gc.textExtent(status);
                int statusX = buttonBounds.x + buttonBounds.width / 2 - statusSize.x / 2;
                int statusY = buttonBounds.y - imageBounds.height - 10 - statusSize.y;
                e.gc.setForeground(UIStyles.getDefaultTextForeground());
                e.gc.setBackground(UIStyles.getDefaultTextBackground());
                e.gc.fillRectangle(statusX - 2, statusY - 2, statusSize.x + 4, statusSize.y + 4);
                e.gc.drawText(status, statusX, statusY, true);
                e.gc.drawRoundRectangle(statusX - 3, statusY - 3, statusSize.x + 5, statusSize.y + 5, 5, 5);
            };
            this.progressPane.addPaintListener(this.painListener);
            this.progressOverlay = new ControlEditor(this.progressPane);
            Point buttonSize = this.cancelButton.computeSize(-1, -1);
            this.progressOverlay.minimumWidth = buttonSize.x;
            this.progressOverlay.minimumHeight = buttonSize.y;
            this.progressOverlay.setEditor((Control)this.cancelButton);
        }
        ++this.drawCount;
        if (this.progressOverlay != null) {
            this.progressOverlay.layout();
            this.progressPane.redraw();
        }
    }

    private void finishProgress() {
        if (this.progressOverlay != null) {
            if (!this.progressPane.isDisposed()) {
                this.progressPane.removePaintListener(this.painListener);
                this.progressOverlay.dispose();
            }
            this.progressOverlay = null;
            if (!this.cancelButton.isDisposed()) {
                this.cancelButton.dispose();
            }
            this.progressPane.redraw();
        }
    }
}

