/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.auth.DBAUserCredentialsProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelDatabaseNative
implements DBAAuthModel {
    public static final String ID = "native";
    public static final AuthModelDatabaseNative INSTANCE = new AuthModelDatabaseNative();

    @Override
    public void initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        String userPassword;
        String userName;
        if (dataSource instanceof DBAUserCredentialsProvider) {
            userName = ((DBAUserCredentialsProvider)((Object)dataSource)).getConnectionUserName(configuration);
            userPassword = ((DBAUserCredentialsProvider)((Object)dataSource)).getConnectionUserPassword(configuration);
        } else {
            userName = configuration.getUserName();
            userPassword = configuration.getUserPassword();
        }
        boolean allowsEmptyPassword = dataSource.getContainer().getDriver().isAllowsEmptyPassword();
        if (userPassword == null && allowsEmptyPassword) {
            userPassword = "";
        }
        if (!CommonUtils.isEmpty((String)userName)) {
            connectProps.put("user", userName);
        }
        if (!CommonUtils.isEmpty((String)userPassword) || allowsEmptyPassword && !CommonUtils.isEmpty((String)userName)) {
            connectProps.put("password", userPassword);
        }
    }

    @Override
    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }
}

