/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardStub;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

class TaskConfigurationWizardPageTask
extends ActiveWizardPage<TaskConfigurationWizard> {
    private static final Log log = Log.getLog(TaskConfigurationWizardPageTask.class);
    private final DBPProject selectedProject;
    private Text taskLabelText;
    private Text taskDescriptionText;
    private Tree taskCategoryTree;
    private DBTTaskCategory selectedCategory;
    private DBTTaskType selectedTaskType;
    private String taskName;
    private String taskDescription;
    private Map<String, Object> initialProperties = new LinkedHashMap<String, Object>();
    private TaskImpl task;
    private Map<DBTTaskType, TaskConfigurationWizard> taskWizards = new HashMap<DBTTaskType, TaskConfigurationWizard>();

    TaskConfigurationWizardPageTask(DBTTask task) {
        super(task == null ? TaskUIMessages.task_config_wizard_page_settings_create_task : TaskUIMessages.task_config_wizard_page_settings_edit_task);
        this.setTitle(task == null ? TaskUIMessages.task_config_wizard_page_task_title_new_task_prop : TaskUIMessages.task_config_wizard_page_settings_title_task_prop);
        this.setDescription(TaskUIMessages.task_config_wizard_page_settings_descr_set_task);
        this.task = (TaskImpl)task;
        if (this.task != null) {
            this.taskName = this.task.getName();
            this.taskDescription = this.task.getDescription();
            this.selectedTaskType = this.task.getType();
            this.selectedCategory = this.selectedTaskType.getCategory();
        }
        this.selectedProject = NavigatorUtils.getSelectedProject();
        this.setPageComplete(false);
    }

    public DBTTaskCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public DBTTaskType getSelectedTaskType() {
        return this.selectedTaskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public Map<String, Object> getInitialProperties() {
        return this.initialProperties;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        boolean taskSaved = this.task != null && !CommonUtils.isEmpty((String)this.task.getId());
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        Group formPanel = UIUtils.createControlGroup((Composite)composite, (String)TaskUIMessages.task_config_wizard_page_task_label_task_type, (int)(this.task == null ? 1 : 2), (int)1808, (int)0);
        formPanel.setLayoutData((Object)new GridData(1808));
        if (this.task == null) {
            this.taskCategoryTree = new Tree((Composite)formPanel, 2052);
            GridData gd = new GridData(1808);
            gd.heightHint = 100;
            gd.widthHint = 200;
            this.taskCategoryTree.setLayoutData((Object)gd);
            this.taskCategoryTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TreeItem[] selection = TaskConfigurationWizardPageTask.this.taskCategoryTree.getSelection();
                    if (selection.length == 1) {
                        Object itemData = selection[0].getData();
                        if (itemData instanceof DBTTaskType) {
                            if (TaskConfigurationWizardPageTask.this.selectedTaskType == itemData) {
                                return;
                            }
                            TaskConfigurationWizardPageTask.this.selectedTaskType = (DBTTaskType)itemData;
                            TaskConfigurationWizardPageTask.this.selectedCategory = TaskConfigurationWizardPageTask.this.selectedTaskType.getCategory();
                        } else {
                            if (TaskConfigurationWizardPageTask.this.selectedCategory == itemData && TaskConfigurationWizardPageTask.this.selectedTaskType == null) {
                                return;
                            }
                            TaskConfigurationWizardPageTask.this.selectedCategory = (DBTTaskCategory)itemData;
                            TaskConfigurationWizardPageTask.this.selectedTaskType = null;
                        }
                        TaskConfigurationWizardPageTask.this.updateTaskTypeSelection();
                    }
                }
            });
            this.addTaskCategories(null, TaskRegistry.getInstance().getRootCategories());
            this.taskCategoryTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (TaskConfigurationWizardPageTask.this.canFlipToNextPage()) {
                        ((TaskConfigurationWizard)TaskConfigurationWizardPageTask.this.getWizard()).getContainer().buttonPressed(15);
                    }
                }
            });
        } else {
            UIUtils.createControlLabel((Composite)formPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_category);
            Composite catPanel = UIUtils.createComposite((Composite)formPanel, (int)2);
            UIUtils.createLabel((Composite)catPanel, (DBPImage)this.task.getType().getCategory().getIcon());
            UIUtils.createLabel((Composite)catPanel, (String)this.task.getType().getCategory().getName());
            UIUtils.createControlLabel((Composite)formPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_type);
            Composite typePanel = UIUtils.createComposite((Composite)formPanel, (int)2);
            UIUtils.createLabel((Composite)typePanel, (DBPImage)this.task.getType().getIcon());
            UIUtils.createLabel((Composite)typePanel, (String)this.task.getType().getName());
        }
        formPanel = UIUtils.createControlGroup((Composite)composite, (String)TaskUIMessages.task_config_wizard_page_task_control_label_task_info, (int)2, (int)1808, (int)0);
        formPanel.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = e -> this.updatePageCompletion();
        this.taskLabelText = UIUtils.createLabelText((Composite)formPanel, (String)TaskUIMessages.task_config_wizard_page_task_text_label_name, (String)(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getName())), (int)2048);
        if (taskSaved) {
            this.taskLabelText.setEditable(false);
        }
        this.taskLabelText.addModifyListener(e -> {
            this.taskName = this.taskLabelText.getText();
            modifyListener.modifyText(e);
        });
        UIUtils.createControlLabel((Composite)formPanel, (String)TaskUIMessages.task_config_wizard_page_task_control_label_descr).setLayoutData((Object)new GridData(2));
        this.taskDescriptionText = new Text((Composite)formPanel, 2562);
        this.taskDescriptionText.setText(this.task == null ? "" : CommonUtils.notEmpty((String)this.task.getDescription()));
        this.taskDescriptionText.setLayoutData((Object)new GridData(768));
        ((GridData)this.taskDescriptionText.getLayoutData()).heightHint = this.taskDescriptionText.getLineHeight() * 6;
        this.taskDescriptionText.addModifyListener(e -> {
            this.taskDescription = this.taskDescriptionText.getText();
            modifyListener.modifyText(e);
        });
        if (this.task != null && !CommonUtils.isEmpty((String)this.task.getId())) {
            UIUtils.createLabelText((Composite)formPanel, (String)TaskUIMessages.task_config_wizard_page_task_text_label_task_id, (String)this.task.getId(), (int)2056);
        }
        UIUtils.asyncExec(() -> {
            boolean bl2 = (taskSaved ? this.taskDescriptionText : this.taskLabelText).setFocus();
        });
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    private void updateTaskTypeSelection() {
        if (this.task != null && this.selectedTaskType != null && this.task.getType() != this.selectedTaskType) {
            this.task.setType(this.selectedTaskType);
            this.task.setProperties(new LinkedHashMap());
        }
        this.updatePageCompletion();
        this.getShell().layout(true, true);
        ((TaskConfigurationWizard)this.getWizard()).getContainer().updateButtons();
    }

    private void addTaskCategories(TreeItem parentItem, DBTTaskCategory[] categories) {
        List<DBTTaskCategory> allCats = Arrays.asList(categories);
        allCats.sort(Comparator.comparing(DBTTaskCategory::getName));
        DBTTaskCategory[] dBTTaskCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskCategory cat = dBTTaskCategoryArray[n2];
            TreeItem item = parentItem == null ? new TreeItem(this.taskCategoryTree, 0) : new TreeItem(parentItem, 0);
            item.setText(cat.getName());
            item.setImage(DBeaverIcons.getImage((DBPImage)(cat.getIcon() == null ? DBIcon.TREE_TASK : cat.getIcon())));
            item.setData((Object)cat);
            this.addTaskCategories(item, cat.getChildren());
            this.addTaskTypes(item, cat);
            item.setExpanded(true);
            ++n2;
        }
    }

    private void addTaskTypes(TreeItem parentItem, DBTTaskCategory category) {
        DBTTaskType[] taskTypes = category.getTaskTypes();
        Arrays.sort(taskTypes, Comparator.comparing(DBTTaskType::getName));
        DBTTaskType[] dBTTaskTypeArray = taskTypes;
        int n = taskTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskType type = dBTTaskTypeArray[n2];
            TreeItem item = new TreeItem(parentItem, 0);
            item.setText(type.getName());
            if (type.getIcon() != null) {
                item.setImage(DBeaverIcons.getImage((DBPImage)type.getIcon()));
            }
            item.setData((Object)type);
            ++n2;
        }
    }

    protected boolean determinePageCompletion() {
        DBTTask task2;
        if (CommonUtils.isEmpty((String)this.taskName)) {
            this.setErrorMessage("Enter task name (unique)");
            return false;
        }
        if (this.task == null && (task2 = this.selectedProject.getTaskManager().getTaskByName(this.taskName)) != null) {
            this.setErrorMessage("Task '" + this.taskName + "' already exists in project '" + this.selectedProject.getName() + "'");
            return false;
        }
        if (this.selectedTaskType == null) {
            this.setErrorMessage("Enter task type");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public TaskConfigurationWizard getTaskWizard() throws DBException {
        if (!(this.getWizard() instanceof TaskConfigurationWizardStub)) {
            return (TaskConfigurationWizard)this.getWizard();
        }
        TaskConfigurationWizard realWizard = this.taskWizards.get(this.selectedTaskType);
        if (realWizard == null) {
            DBTTaskConfigurator configurator = TaskUIRegistry.getInstance().createConfigurator(this.selectedTaskType);
            if (this.task == null) {
                this.task = (TaskImpl)this.selectedProject.getTaskManager().createTask(this.selectedTaskType, CommonUtils.notEmpty((String)this.taskName), this.taskDescription, new LinkedHashMap());
            }
            realWizard = configurator.createTaskConfigWizard((DBTTask)this.task);
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            IWorkbenchPart activePart = workbenchWindow.getActivePage().getActivePart();
            ISelection selection = activePart == null || activePart.getSite() == null || activePart.getSite().getSelectionProvider() == null ? null : activePart.getSite().getSelectionProvider().getSelection();
            realWizard.setContainer(this.getContainer());
            realWizard.init(workbenchWindow.getWorkbench(), selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null);
            this.taskWizards.put(this.selectedTaskType, realWizard);
        }
        return realWizard;
    }

    public void saveSettings() {
        if (this.task != null) {
            this.task.setName(this.taskLabelText.getText());
            this.task.setDescription(this.taskDescriptionText.getText());
            this.task.setType(this.selectedTaskType);
        }
    }
}

