/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;

public class DB2ForeignKeyManager
extends SQLForeignKeyManager<DB2TableForeignKey, DB2Table> {
    private static final String SQL_DROP_FK = "ALTER TABLE %s DROP FOREIGN KEY %s";
    private static final String SQL_ALTER = "ALTER TABLE %s ALTER FOREIGN KEY %s";
    private static final String CONS_FK_NAME = "%s_%s_FK";

    public boolean canEditObject(DB2TableForeignKey object) {
        return false;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2TableForeignKey> getObjectsCache(DB2TableForeignKey object) {
        return ((DB2Table)object.getParentObject()).getSchema().getAssociationCache();
    }

    public DB2TableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object table, Object from, Map<String, Object> options) {
        return new DB2TableForeignKey((DB2Table)table, null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        throw new IllegalStateException("Object modification is not supported in " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public String getDropForeignKeyPattern(DB2TableForeignKey foreignKey) {
        String tableName = ((DB2Table)foreignKey.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        return String.format(SQL_DROP_FK, tableName, foreignKey.getName());
    }
}

