/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.HexEditControl;
import org.jkiss.dbeaver.utils.ContentUtils;

public class BinaryClipboard {
    private static final Log log = Log.getLog(HexEditControl.class);
    private static final File clipboardDir = new File(System.getProperty("java.io.tmpdir", "."));
    private static final File clipboardFile = new File(clipboardDir, "dbeaver-binary-clipboard.tmp");
    private static final long maxClipboardDataInMemory = 0x400000L;
    private final Map<File, Integer> filesReferencesCounter = new HashMap<File, Integer>();
    private final Clipboard clipboard;

    public BinaryClipboard(Display aDisplay) {
        this.clipboard = new Clipboard(aDisplay);
    }

    public void dispose() throws IOException {
        if (!this.clipboard.isDisposed()) {
            File lastPaste = (File)this.clipboard.getContents((Transfer)FileByteArrayTransfer.getInstance());
            this.clipboard.dispose();
            if (!clipboardFile.equals(lastPaste)) {
                this.emptyClipboardFile();
            }
        }
        for (File aFile : this.filesReferencesCounter.keySet()) {
            int count = this.filesReferencesCounter.get(aFile);
            File lock = BinaryClipboard.getLockFromFile(aFile);
            if (!this.updateLock(lock, -count) || aFile.delete()) continue;
            aFile.deleteOnExit();
        }
    }

    void emptyClipboardFile() {
        if (clipboardFile.canWrite() && clipboardFile.length() > 0L) {
            try {
                RandomAccessFile file = new RandomAccessFile(clipboardFile, "rw");
                try {
                    file.setLength(0L);
                }
                finally {
                    ContentUtils.close((Closeable)file);
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public long getContents(BinaryContent content, long start, boolean insert) {
        long total = this.tryGettingFiles(content, start, insert);
        if (total >= 0L) {
            return total;
        }
        total = this.tryGettingMemoryByteArray(content, start, insert);
        if (total >= 0L) {
            return total;
        }
        total = this.tryGettingFileByteArray(content, start, insert);
        if (total >= 0L) {
            return total;
        }
        return 0L;
    }

    static File getLockFromFile(File lastPaste) {
        String name = lastPaste.getAbsolutePath();
        return new File(String.valueOf(name.substring(0, name.length() - 3)) + "lock");
    }

    public boolean hasContents() {
        TransferData[] available = this.clipboard.getAvailableTypes();
        int i = 0;
        while (i < available.length) {
            if (MemoryByteArrayTransfer.getInstance().isSupportedType(available[i]) || TextTransfer.getInstance().isSupportedType(available[i]) || FileByteArrayTransfer.getInstance().isSupportedType(available[i]) || FileTransfer.getInstance().isSupportedType(available[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setContents(BinaryContent content, long start, long length) {
        Object[] data;
        Transfer[] transfers;
        if (length < 1L) {
            return;
        }
        try {
            if (length <= 0x400000L) {
                byte[] byteArrayData = new byte[(int)length];
                content.get(ByteBuffer.wrap(byteArrayData), start);
                String textData = new String(byteArrayData);
                transfers = new Transfer[]{MemoryByteArrayTransfer.getInstance(), TextTransfer.getInstance()};
                data = new Object[]{byteArrayData, textData};
            } else {
                content.get(clipboardFile, start, length);
                transfers = new Transfer[]{FileByteArrayTransfer.getInstance()};
                data = new Object[]{clipboardFile};
            }
        }
        catch (IOException iOException) {
            this.clipboard.setContents(new Object[]{new byte[1]}, new Transfer[]{MemoryByteArrayTransfer.getInstance()});
            this.clipboard.clearContents();
            this.emptyClipboardFile();
            return;
        }
        this.clipboard.setContents(data, transfers);
    }

    long tryGettingFileByteArray(BinaryContent content, long start, boolean insert) {
        File lock;
        File lastPaste = (File)this.clipboard.getContents((Transfer)FileByteArrayTransfer.getInstance());
        if (lastPaste == null) {
            return -1L;
        }
        long total = lastPaste.length();
        if (!insert && total > content.length() - start) {
            return 0L;
        }
        if (clipboardFile.equals(lastPaste)) {
            int i = 0;
            while (true) {
                StringBuilder name = new StringBuilder("binaryPasted").append(i);
                lastPaste = new File(clipboardDir, String.valueOf(name.toString()) + ".tmp");
                lock = new File(clipboardDir, name.append(".lock").toString());
                if (!lock.exists() && (!lastPaste.exists() || lastPaste.delete())) break;
                ++i;
            }
            if (lastPaste.exists() || lock.exists()) {
                return 0L;
            }
            if (!clipboardFile.renameTo(lastPaste)) {
                log.warn((Object)"Can't rename clipboard temp file");
            }
            this.clipboard.setContents(new Object[]{lastPaste}, new Transfer[]{FileByteArrayTransfer.getInstance()});
        } else {
            lock = BinaryClipboard.getLockFromFile(lastPaste);
        }
        try {
            if (insert) {
                content.insert(lastPaste, start);
            } else {
                content.overwrite(lastPaste, start);
            }
        }
        catch (IOException iOException) {
            total = 0L;
        }
        if (total > 0L) {
            try {
                this.updateLock(lock, 1);
            }
            catch (IOException iOException) {
                this.filesReferencesCounter.remove(lastPaste);
                return total;
            }
            Integer value = this.filesReferencesCounter.put(lastPaste, 1);
            if (value != null) {
                this.filesReferencesCounter.put(lastPaste, value + 1);
            }
        }
        return total;
    }

    long tryGettingFiles(BinaryContent content, long start, boolean insert) {
        File file;
        int i;
        String[] files = (String[])this.clipboard.getContents((Transfer)FileTransfer.getInstance());
        if (files == null) {
            return -1L;
        }
        long total = 0L;
        if (!insert) {
            i = 0;
            while (i < files.length) {
                file = new File(files[i]);
                if ((total += file.length()) > content.length() - start) {
                    return 0L;
                }
                ++i;
            }
        }
        total = 0L;
        i = files.length - 1;
        while (i >= 0) {
            file = new File(files[i]);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            boolean success = true;
            try {
                if (insert) {
                    content.insert(file, start);
                } else {
                    content.overwrite(file, start);
                }
            }
            catch (IOException iOException) {
                success = false;
            }
            if (success) {
                start += file.length();
                total += file.length();
            }
            --i;
        }
        return total;
    }

    long tryGettingMemoryByteArray(BinaryContent content, long start, boolean insert) {
        String text;
        byte[] byteArray = (byte[])this.clipboard.getContents((Transfer)MemoryByteArrayTransfer.getInstance());
        if (byteArray == null && (text = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance())) != null) {
            byteArray = text.getBytes(Charset.defaultCharset());
        }
        if (byteArray == null) {
            return -1L;
        }
        long total = byteArray.length;
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        if (insert) {
            content.insert(buffer, start);
        } else if (total <= content.length() - start) {
            content.overwrite(buffer, start);
        } else {
            total = 0L;
        }
        return total;
    }

    boolean updateLock(File lock, int references) throws IOException {
        RandomAccessFile file = new RandomAccessFile(lock, "rw");
        try {
            if (file.length() >= 4L) {
                references += file.readInt();
            }
            if (references > 0) {
                file.seek(0L);
                file.writeInt(references);
            }
        }
        finally {
            ContentUtils.close((Closeable)file);
        }
        if (references < 1) {
            if (!lock.delete()) {
                log.warn((Object)("Cannot delete lock file '" + lock.getAbsolutePath() + "'"));
            }
            return true;
        }
        return false;
    }

    static class FileByteArrayTransfer
    extends ByteArrayTransfer {
        static final String FORMAT_NAME = "BinaryFileByteArrayTypeName";
        static final int FORMAT_ID = FileByteArrayTransfer.registerType((String)"BinaryFileByteArrayTypeName");
        static final FileByteArrayTransfer instance = new FileByteArrayTransfer();

        private FileByteArrayTransfer() {
        }

        static FileByteArrayTransfer getInstance() {
            return instance;
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof File)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                File myType = (File)object;
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    DataOutputStream writeOut = new DataOutputStream(out);
                    byte[] buffer = myType.getAbsolutePath().getBytes(Charset.defaultCharset());
                    writeOut.writeInt(buffer.length);
                    writeOut.write(buffer);
                    buffer = out.toByteArray();
                    writeOut.close();
                    super.javaToNative((Object)buffer, transferData);
                }
                catch (IOException e) {
                    log.warn((Object)e);
                }
            }
        }

        public Object nativeToJava(TransferData transferData) {
            byte[] nameBytes;
            block7: {
                int size;
                DataInputStream readIn;
                block6: {
                    if (!this.isSupportedType(transferData)) {
                        return null;
                    }
                    byte[] buffer = (byte[])super.nativeToJava(transferData);
                    if (buffer == null) {
                        return null;
                    }
                    readIn = new DataInputStream(new ByteArrayInputStream(buffer));
                    try {
                        size = readIn.readInt();
                        if (size > 0) break block6;
                        return null;
                    }
                    catch (IOException ex) {
                        log.warn((Object)ex);
                        return null;
                    }
                }
                nameBytes = new byte[size];
                if (readIn.read(nameBytes) >= size) break block7;
                return null;
            }
            return new File(new String(nameBytes));
        }

        protected String[] getTypeNames() {
            return new String[]{FORMAT_NAME};
        }

        protected int[] getTypeIds() {
            return new int[]{FORMAT_ID};
        }
    }

    static class MemoryByteArrayTransfer
    extends ByteArrayTransfer {
        static final String FORMAT_NAME = "BinaryMemoryByteArrayTypeName";
        static final int FORMAT_ID = MemoryByteArrayTransfer.registerType((String)"BinaryMemoryByteArrayTypeName");
        static final MemoryByteArrayTransfer instance = new MemoryByteArrayTransfer();

        private MemoryByteArrayTransfer() {
        }

        static MemoryByteArrayTransfer getInstance() {
            return instance;
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof byte[])) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])object;
                super.javaToNative((Object)buffer, transferData);
            }
        }

        public Object nativeToJava(TransferData transferData) {
            Object result = null;
            if (this.isSupportedType(transferData)) {
                result = super.nativeToJava(transferData);
            }
            return result;
        }

        protected String[] getTypeNames() {
            return new String[]{FORMAT_NAME};
        }

        protected int[] getTypeIds() {
            return new int[]{FORMAT_ID};
        }
    }
}

