/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

@Deprecated
class DataSourceSerializerLegacy
implements DataSourceSerializer {
    private static final Log log = Log.getLog(DataSourceSerializerLegacy.class);
    private static PasswordEncrypter ENCRYPTOR = new SimpleStringEncrypter();
    private final DataSourceRegistry registry;

    public DataSourceSerializerLegacy(DataSourceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void saveDataSources(DBRProgressMonitor monitor, DBPDataSourceConfigurationStorage configurationStorage, List<DataSourceDescriptor> localDataSources, IFile configFile) throws DBException, IOException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream(10000);
        try {
            XMLBuilder xml;
            block28: {
                xml = new XMLBuilder((OutputStream)tempStream, GeneralUtils.UTF8_ENCODING);
                xml.setButify(true);
                Throwable throwable = null;
                Object var8_11 = null;
                try (XMLBuilder.Element el1 = xml.startElement("data-sources");){
                    if (configurationStorage.isDefault()) {
                        for (DataSourceFolder folder : this.registry.getAllFolders()) {
                            DataSourceSerializerLegacy.saveFolder(xml, folder);
                        }
                    }
                    for (DataSourceDescriptor dataSource : localDataSources) {
                        if (dataSource.isTemporary()) continue;
                        DataSourceSerializerLegacy.saveDataSource(xml, dataSource);
                    }
                    if (!configurationStorage.isDefault()) break block28;
                    Throwable throwable2 = null;
                    Iterator<Object> iterator = null;
                    try (XMLBuilder.Element ignored = xml.startElement("filters");){
                        for (DBSObjectFilter cf : this.registry.getSavedFilters()) {
                            if (cf.isEmpty()) continue;
                            DataSourceSerializerLegacy.saveObjectFiler(xml, null, null, cf);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            xml.flush();
        }
        catch (IOException ex) {
            log.error((Object)"IO error while saving datasources xml", (Throwable)ex);
        }
        ByteArrayInputStream ifs = new ByteArrayInputStream(tempStream.toByteArray());
        try {
            if (!configFile.exists()) {
                configFile.create((InputStream)ifs, true, monitor.getNestedMonitor());
                configFile.setHidden(true);
            } else {
                configFile.setContents((InputStream)ifs, true, false, monitor.getNestedMonitor());
            }
        }
        catch (CoreException e) {
            throw new IOException("Error saving configuration to a file " + configFile.getFullPath(), e);
        }
    }

    @Override
    public void parseDataSources(IFile configFile, DBPDataSourceConfigurationStorage configurationStorage, boolean refresh, DataSourceRegistry.ParseResults parseResults) throws DBException, IOException {
        try {
            SAXReader parser = new SAXReader(configFile.getContents());
            DataSourcesParser dsp = new DataSourcesParser(this.registry, configurationStorage, refresh, parseResults);
            parser.parse((SAXListener)dsp);
        }
        catch (Exception ex) {
            throw new DBException("Datasource config parse error", (Throwable)ex);
        }
    }

    private static void saveFolder(XMLBuilder xml, DataSourceFolder folder) throws IOException {
        xml.startElement("folder");
        if (folder.getParent() != null) {
            xml.addAttribute("parent", folder.getParent().getFolderPath());
        }
        xml.addAttribute("name", folder.getName());
        if (!CommonUtils.isEmpty((String)folder.getDescription())) {
            xml.addAttribute("description", folder.getDescription());
        }
        xml.endElement();
    }

    private static void saveDataSource(XMLBuilder xml, DataSourceDescriptor dataSource) throws IOException {
        String lockPasswordHash;
        xml.startElement("data-source");
        xml.addAttribute("id", dataSource.getId());
        xml.addAttribute("provider", dataSource.getDriver().getProviderDescriptor().getId());
        xml.addAttribute("driver", dataSource.getDriver().getId());
        xml.addAttribute("name", dataSource.getName());
        xml.addAttribute("save-password", dataSource.isSavePassword());
        DataSourceNavigatorSettings navSettings = dataSource.getNavigatorSettings();
        if (navSettings.isShowSystemObjects()) {
            xml.addAttribute("show-system-objects", navSettings.isShowSystemObjects());
        }
        if (navSettings.isShowUtilityObjects()) {
            xml.addAttribute("show-util-objects", navSettings.isShowUtilityObjects());
        }
        xml.addAttribute("read-only", dataSource.isConnectionReadOnly());
        if (dataSource.getFolder() != null) {
            xml.addAttribute("folder", dataSource.getFolder().getFolderPath());
        }
        if (!CommonUtils.isEmpty((String)(lockPasswordHash = dataSource.getLockPasswordHash()))) {
            xml.addAttribute("lockPassword", lockPasswordHash);
        }
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        xml.startElement("connection");
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
            xml.addAttribute("host", connectionInfo.getHostName());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            xml.addAttribute("port", connectionInfo.getHostPort());
        }
        xml.addAttribute("server", CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        xml.addAttribute("database", CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        xml.addAttribute("url", CommonUtils.notEmpty((String)connectionInfo.getUrl()));
        DataSourceSerializerLegacy.saveSecuredCredentials(xml, dataSource.getRegistry().getProject(), dataSource, null, connectionInfo.getUserName(), dataSource.isSavePassword() ? connectionInfo.getUserPassword() : null);
        if (!CommonUtils.isEmpty((String)connectionInfo.getClientHomeId())) {
            xml.addAttribute("home", connectionInfo.getClientHomeId());
        }
        if (connectionInfo.getConnectionType() != null) {
            xml.addAttribute("type", connectionInfo.getConnectionType().getId());
        }
        if (connectionInfo.getConnectionColor() != null) {
            xml.addAttribute("color", connectionInfo.getConnectionColor());
        }
        if (connectionInfo.getKeepAliveInterval() > 0) {
            xml.addAttribute("keepAlive", connectionInfo.getKeepAliveInterval());
        }
        for (Map.Entry entry : connectionInfo.getProperties().entrySet()) {
            xml.startElement("property");
            xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
            xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
            xml.endElement();
        }
        for (Map.Entry entry : connectionInfo.getProviderProperties().entrySet()) {
            xml.startElement("provider-property");
            xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
            xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
            xml.endElement();
        }
        Object object = connectionInfo.getDeclaredEvents();
        int n = ((DBPConnectionEventType[])object).length;
        int n2 = 0;
        while (n2 < n) {
            DBPConnectionEventType eventType = object[n2];
            DBRShellCommand command = connectionInfo.getEvent(eventType);
            xml.startElement("event");
            xml.addAttribute("type", eventType.name());
            xml.addAttribute("enabled", command.isEnabled());
            xml.addAttribute("show-panel", command.isShowProcessPanel());
            xml.addAttribute("wait-process", command.isWaitProcessFinish());
            if (command.isWaitProcessFinish()) {
                xml.addAttribute("wait-process-timeout", command.getWaitProcessTimeoutMs());
            }
            xml.addAttribute("terminate-at-disconnect", command.isTerminateAtDisconnect());
            xml.addAttribute("pauseAfterExecute", command.getPauseAfterExecute());
            if (!CommonUtils.isEmpty((String)command.getWorkingDirectory())) {
                xml.addAttribute("workingDirectory", command.getWorkingDirectory());
            }
            xml.addText((CharSequence)command.getCommand());
            xml.endElement();
            ++n2;
        }
        for (DBWHandlerConfiguration configuration : connectionInfo.getHandlers()) {
            xml.startElement("network-handler");
            xml.addAttribute("type", configuration.getType().name());
            xml.addAttribute("id", CommonUtils.notEmpty((String)configuration.getId()));
            xml.addAttribute("enabled", configuration.isEnabled());
            xml.addAttribute("save-password", configuration.isSavePassword());
            if (!CommonUtils.isEmpty((String)configuration.getUserName())) {
                DataSourceSerializerLegacy.saveSecuredCredentials(xml, dataSource.getRegistry().getProject(), dataSource, "network/" + configuration.getId(), configuration.getUserName(), configuration.isSavePassword() ? configuration.getPassword() : null);
            }
            for (Map.Entry entry : configuration.getProperties().entrySet()) {
                if (entry.getValue() == null) continue;
                xml.startElement("property");
                xml.addAttribute("name", (String)entry.getKey());
                xml.addAttribute("value", CommonUtils.notEmpty((String)entry.getValue().toString()));
                xml.endElement();
            }
            xml.endElement();
        }
        DBPConnectionBootstrap bootstrap = connectionInfo.getBootstrap();
        if (bootstrap.hasData()) {
            xml.startElement("bootstrap");
            if (bootstrap.getDefaultAutoCommit() != null) {
                xml.addAttribute("autocommit", bootstrap.getDefaultAutoCommit().booleanValue());
            }
            if (bootstrap.getDefaultTransactionIsolation() != null) {
                xml.addAttribute("txnIsolation", bootstrap.getDefaultTransactionIsolation().intValue());
            }
            if (!CommonUtils.isEmpty((String)bootstrap.getDefaultCatalogName())) {
                xml.addAttribute("defaultObject", bootstrap.getDefaultCatalogName());
            }
            if (bootstrap.isIgnoreErrors()) {
                xml.addAttribute("ignoreErrors", true);
            }
            for (String query : bootstrap.getInitQueries()) {
                xml.startElement("query");
                xml.addText((CharSequence)query);
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
        Collection<FilterMapping> filterMappings = dataSource.getObjectFilters();
        if (!CommonUtils.isEmpty(filterMappings)) {
            xml.startElement("filters");
            for (FilterMapping filter : filterMappings) {
                if (filter.defaultFilter != null && !filter.defaultFilter.isEmpty()) {
                    DataSourceSerializerLegacy.saveObjectFiler(xml, filter.typeName, null, filter.defaultFilter);
                }
                for (Map.Entry entry : filter.customFilters.entrySet()) {
                    if (((DBSObjectFilter)entry.getValue()).isEmpty()) continue;
                    DataSourceSerializerLegacy.saveObjectFiler(xml, filter.typeName, (String)entry.getKey(), (DBSObjectFilter)entry.getValue());
                }
            }
            xml.endElement();
        }
        if (dataSource.getVirtualModel().hasValuableData()) {
            xml.startElement("virtual-meta-data");
            dataSource.getVirtualModel().serialize(xml);
            xml.endElement();
        }
        DataSourcePreferenceStore prefStore = dataSource.getPreferenceStore();
        object = prefStore.preferenceNames();
        int n3 = ((String[])object).length;
        int n32 = 0;
        while (n32 < n3) {
            DBPConnectionEventType propName = object[n32];
            String propValue = prefStore.getString((String)propName);
            String defValue = prefStore.getDefaultString((String)propName);
            if (propValue != null && !CommonUtils.equalObjects((Object)propValue, (Object)defValue)) {
                xml.startElement("custom-property");
                xml.addAttribute("name", (String)propName);
                xml.addAttribute("value", propValue);
                xml.endElement();
            }
            ++n32;
        }
        if (!CommonUtils.isEmpty((String)dataSource.getDescription())) {
            xml.startElement("description");
            xml.addText((CharSequence)dataSource.getDescription());
            xml.endElement();
        }
        xml.endElement();
    }

    private static void saveSecuredCredentials(@NotNull XMLBuilder xml, @NotNull DBPProject project, @Nullable DataSourceDescriptor dataSource, String subNode, String userName, String password) throws IOException {
        boolean saved = DataSourceUtils.saveCredentialsInSecuredStorage(project, dataSource, subNode, userName, password);
        if (!saved) {
            try {
                if (!CommonUtils.isEmpty((String)userName)) {
                    xml.addAttribute("user", CommonUtils.notEmpty((String)userName));
                }
                if (!CommonUtils.isEmpty((String)password)) {
                    xml.addAttribute("password", ENCRYPTOR.encrypt(password));
                }
            }
            catch (EncryptionException e) {
                log.error((Object)"Error encrypting password", (Throwable)e);
            }
        }
    }

    private static void saveObjectFiler(XMLBuilder xml, String typeName, String objectID, DBSObjectFilter filter) throws IOException {
        xml.startElement("filter");
        if (typeName != null) {
            xml.addAttribute("type", typeName);
        }
        if (objectID != null) {
            xml.addAttribute("id", objectID);
        }
        if (!CommonUtils.isEmpty((String)filter.getName())) {
            xml.addAttribute("name", filter.getName());
        }
        if (!CommonUtils.isEmpty((String)filter.getDescription())) {
            xml.addAttribute("description", filter.getDescription());
        }
        if (!filter.isEnabled()) {
            xml.addAttribute("enabled", false);
        }
        for (String include : CommonUtils.safeCollection((Collection)filter.getInclude())) {
            xml.startElement("include");
            xml.addAttribute("name", include);
            xml.endElement();
        }
        for (String exclude : CommonUtils.safeCollection((Collection)filter.getExclude())) {
            xml.startElement("exclude");
            xml.addAttribute("name", exclude);
            xml.endElement();
        }
        xml.endElement();
    }

    @Nullable
    private static String decryptPassword(String encPassword) {
        if (!CommonUtils.isEmpty((String)encPassword)) {
            try {
                encPassword = ENCRYPTOR.decrypt(encPassword);
            }
            catch (Throwable throwable) {
                encPassword = null;
            }
        }
        return encPassword;
    }

    private class DataSourcesParser
    implements SAXListener {
        DataSourceRegistry registry;
        DataSourceDescriptor curDataSource;
        DBPDataSourceConfigurationStorage origin;
        boolean refresh;
        boolean isDescription = false;
        DBRShellCommand curCommand = null;
        private DBWHandlerConfiguration curNetworkHandler;
        private DBSObjectFilter curFilter;
        private StringBuilder curQuery;
        private DataSourceRegistry.ParseResults parseResults;
        private boolean passwordReadCanceled = false;

        private DataSourcesParser(DataSourceRegistry registry, DBPDataSourceConfigurationStorage origin, boolean refresh, DataSourceRegistry.ParseResults parseResults) {
            this.registry = registry;
            this.origin = origin;
            this.refresh = refresh;
            this.parseResults = parseResults;
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) {
            this.isDescription = false;
            this.curCommand = null;
            block18 : switch (localName) {
                case "folder": {
                    DataSourceFolder folder;
                    String name = atts.getValue("name");
                    String description = atts.getValue("description");
                    String parentFolder = atts.getValue("parent");
                    DataSourceFolder parent = parentFolder == null ? null : this.registry.findFolderByPath(parentFolder, true);
                    DataSourceFolder dataSourceFolder = folder = parent == null ? this.registry.findFolderByPath(name, true) : parent.getChild(name);
                    if (folder == null) {
                        folder = new DataSourceFolder(this.registry, parent, name, description);
                        this.registry.addDataSourceFolder(folder);
                        break;
                    }
                    folder.setDescription(description);
                    break;
                }
                case "data-source": {
                    String legacySchemaFilter;
                    boolean newDataSource;
                    String name = atts.getValue("name");
                    String id = atts.getValue("id");
                    if (id == null) {
                        id = name;
                    }
                    String providerId = atts.getValue("provider");
                    DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                    if (provider == null) {
                        log.warn((Object)("Can't find datasource provider " + providerId + " for datasource '" + name + "'"));
                        this.curDataSource = null;
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    String driverId = atts.getValue("driver");
                    DriverDescriptor driver = provider.getDriver(driverId);
                    if (driver == null) {
                        log.warn((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + name + "'. Create new driver"));
                        driver = provider.createDriver(driverId);
                        provider.addDriver(driver);
                    }
                    this.curDataSource = this.registry.getDataSource(id);
                    boolean bl = newDataSource = this.curDataSource == null;
                    if (newDataSource) {
                        this.curDataSource = new DataSourceDescriptor(this.registry, this.origin, id, driver, new DBPConnectionConfiguration());
                    } else {
                        this.curDataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                        this.curDataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                        this.curDataSource.clearFilters();
                    }
                    this.curDataSource.setName(name);
                    this.curDataSource.setSavePassword(CommonUtils.getBoolean((String)atts.getValue("save-password")));
                    DataSourceNavigatorSettings navSettings = this.curDataSource.getNavigatorSettings();
                    navSettings.setShowSystemObjects(CommonUtils.getBoolean((String)atts.getValue("show-system-objects")));
                    navSettings.setShowUtilityObjects(CommonUtils.getBoolean((String)atts.getValue("show-util-objects")));
                    navSettings.setShowOnlyEntities(CommonUtils.getBoolean((String)atts.getValue("navigator-show-only-entities")));
                    navSettings.setHideFolders(CommonUtils.getBoolean((String)atts.getValue("navigator-hide-folders")));
                    navSettings.setHideSchemas(CommonUtils.getBoolean((String)atts.getValue("navigator-hide-schemas")));
                    navSettings.setHideVirtualModel(CommonUtils.getBoolean((String)atts.getValue("navigator-hide-virtual")));
                    navSettings.setMergeEntities(CommonUtils.getBoolean((String)atts.getValue("navigator-merge-entities")));
                    this.curDataSource.setConnectionReadOnly(CommonUtils.getBoolean((String)atts.getValue("read-only")));
                    String folderPath = atts.getValue("folder");
                    if (folderPath != null) {
                        this.curDataSource.setFolder(this.registry.findFolderByPath(folderPath, true));
                    }
                    this.curDataSource.setLockPasswordHash(atts.getValue("lockPassword"));
                    String legacyCatalogFilter = atts.getValue("filter-catalog");
                    if (!CommonUtils.isEmpty((String)legacyCatalogFilter)) {
                        this.curDataSource.updateObjectFilter(DBSCatalog.class.getName(), null, new DBSObjectFilter(legacyCatalogFilter, null));
                    }
                    if (!CommonUtils.isEmpty((String)(legacySchemaFilter = atts.getValue("filter-schema")))) {
                        this.curDataSource.updateObjectFilter(DBSSchema.class.getName(), null, new DBSObjectFilter(legacySchemaFilter, null));
                    }
                    if (newDataSource) {
                        this.registry.addDataSourceToList(this.curDataSource);
                        this.parseResults.addedDataSources.add(this.curDataSource);
                        break;
                    }
                    this.parseResults.updatedDataSources.add(this.curDataSource);
                    break;
                }
                case "connection": {
                    String keepAlive;
                    if (this.curDataSource == null) break;
                    DriverDescriptor driver = this.curDataSource.getDriver();
                    if (CommonUtils.isEmpty((String)driver.getName())) {
                        driver.setName(atts.getValue("url"));
                        driver.setDriverClassName("java.sql.Driver");
                    }
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    config.setHostName(atts.getValue("host"));
                    config.setHostPort(atts.getValue("port"));
                    config.setServerName(atts.getValue("server"));
                    config.setDatabaseName(atts.getValue("database"));
                    config.setUrl(atts.getValue("url"));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(atts, this.curDataSource, null);
                        config.setUserName(creds[0]);
                        if (this.curDataSource.isSavePassword()) {
                            config.setUserPassword(creds[1]);
                        }
                    }
                    config.setClientHomeId(atts.getValue("home"));
                    config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(CommonUtils.toString((Object)atts.getValue("type")), DBPConnectionType.DEFAULT_TYPE));
                    String colorValue = atts.getValue("color");
                    if (!CommonUtils.isEmpty((String)colorValue)) {
                        config.setConnectionColor(colorValue);
                    }
                    if (CommonUtils.isEmpty((String)(keepAlive = atts.getValue("keepAlive")))) break;
                    try {
                        config.setKeepAliveInterval(Integer.parseInt(keepAlive));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)"Bad keep-alive interval value", (Throwable)e);
                    }
                    break;
                }
                case "bootstrap": {
                    if (this.curDataSource == null) break;
                    DBPConnectionConfiguration config = this.curDataSource.getConnectionConfiguration();
                    if (atts.getValue("autocommit") != null) {
                        config.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)atts.getValue("autocommit"))));
                    }
                    if (atts.getValue("txnIsolation") != null) {
                        config.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)atts.getValue("txnIsolation"))));
                    }
                    if (!CommonUtils.isEmpty((String)atts.getValue("defaultObject"))) {
                        config.getBootstrap().setDefaultCatalogName(atts.getValue("defaultObject"));
                    }
                    if (atts.getValue("ignoreErrors") == null) break;
                    config.getBootstrap().setIgnoreErrors(CommonUtils.toBoolean((Object)atts.getValue("ignoreErrors")));
                    break;
                }
                case "query": {
                    this.curQuery = new StringBuilder();
                    break;
                }
                case "property": {
                    if (this.curNetworkHandler != null) {
                        this.curNetworkHandler.setProperty(atts.getValue("name"), (Object)atts.getValue("value"));
                        break;
                    }
                    if (this.curDataSource == null) break;
                    String propName = atts.getValue("name");
                    String propValue = atts.getValue("value");
                    if (propName == null) break;
                    if (propName.startsWith("@dbeaver-")) {
                        this.curDataSource.getConnectionConfiguration().setProviderProperty(propName, propValue);
                        break;
                    }
                    this.curDataSource.getConnectionConfiguration().setProperty(propName, propValue);
                    break;
                }
                case "provider-property": {
                    if (this.curDataSource == null) break;
                    this.curDataSource.getConnectionConfiguration().setProviderProperty(atts.getValue("name"), atts.getValue("value"));
                    break;
                }
                case "event": {
                    if (this.curDataSource == null) break;
                    DBPConnectionEventType eventType = DBPConnectionEventType.valueOf((String)atts.getValue("type"));
                    this.curCommand = new DBRShellCommand("");
                    this.curCommand.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled")));
                    this.curCommand.setShowProcessPanel(CommonUtils.getBoolean((String)atts.getValue("show-panel")));
                    this.curCommand.setWaitProcessFinish(CommonUtils.getBoolean((String)atts.getValue("wait-process")));
                    if (this.curCommand.isWaitProcessFinish()) {
                        String timeoutString = atts.getValue("wait-process-timeout");
                        int timeoutMs = CommonUtils.toInt((Object)timeoutString, (int)-1);
                        this.curCommand.setWaitProcessTimeoutMs(timeoutMs);
                    }
                    this.curCommand.setTerminateAtDisconnect(CommonUtils.getBoolean((String)atts.getValue("terminate-at-disconnect")));
                    this.curCommand.setPauseAfterExecute(CommonUtils.toInt((Object)atts.getValue("pauseAfterExecute")));
                    this.curCommand.setWorkingDirectory(atts.getValue("workingDirectory"));
                    this.curDataSource.getConnectionConfiguration().setEvent(eventType, this.curCommand);
                    break;
                }
                case "custom-property": {
                    if (this.curDataSource == null) break;
                    String propName = atts.getValue("name");
                    String propValue = atts.getValue("value");
                    switch (propName) {
                        case "default.autocommit": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultAutoCommit(Boolean.valueOf(CommonUtils.toBoolean((Object)propValue)));
                            break block18;
                        }
                        case "default.isolation": {
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(CommonUtils.toInt((Object)propValue)));
                            break block18;
                        }
                        case "default.activeObject": {
                            if (CommonUtils.isEmpty((String)propValue)) break block18;
                            this.curDataSource.getConnectionConfiguration().getBootstrap().setDefaultCatalogName(propValue);
                            break block18;
                        }
                    }
                    this.curDataSource.getPreferenceStore().getProperties().put(propName, propValue);
                    break;
                }
                case "network-handler": {
                    if (this.curDataSource == null) break;
                    String handlerId = atts.getValue("id");
                    NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
                    if (handlerDescriptor == null) {
                        log.warn((Object)("Can't find network handler '" + handlerId + "'"));
                        reader.setListener(EMPTY_LISTENER);
                        return;
                    }
                    this.curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDataSourceContainer)this.curDataSource);
                    this.curNetworkHandler.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled")));
                    this.curNetworkHandler.setSavePassword(CommonUtils.getBoolean((String)atts.getValue("save-password")));
                    if (!this.passwordReadCanceled) {
                        String[] creds = this.readSecuredCredentials(atts, this.curDataSource, "network/" + handlerId);
                        this.curNetworkHandler.setUserName(creds[0]);
                        if (this.curNetworkHandler.isSavePassword()) {
                            this.curNetworkHandler.setPassword(creds[1]);
                        }
                    }
                    this.curDataSource.getConnectionConfiguration().updateHandler(this.curNetworkHandler);
                    break;
                }
                case "filter": {
                    if (this.curDataSource != null) {
                        String typeName = atts.getValue("type");
                        String objectID = atts.getValue("id");
                        if (typeName == null) break;
                        this.curFilter = new DBSObjectFilter();
                        this.curFilter.setName(atts.getValue("name"));
                        this.curFilter.setDescription(atts.getValue("description"));
                        this.curFilter.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled"), (boolean)true));
                        this.curDataSource.updateObjectFilter(typeName, objectID, this.curFilter);
                        break;
                    }
                    this.curFilter = new DBSObjectFilter();
                    this.curFilter.setName(atts.getValue("name"));
                    this.curFilter.setDescription(atts.getValue("description"));
                    this.curFilter.setEnabled(CommonUtils.getBoolean((String)atts.getValue("enabled"), (boolean)true));
                    this.registry.addSavedFilter(this.curFilter);
                    break;
                }
                case "include": {
                    if (this.curFilter == null) break;
                    this.curFilter.addInclude(CommonUtils.notEmpty((String)atts.getValue("name")));
                    break;
                }
                case "exclude": {
                    if (this.curFilter == null) break;
                    this.curFilter.addExclude(CommonUtils.notEmpty((String)atts.getValue("name")));
                    break;
                }
                case "description": {
                    this.isDescription = true;
                    break;
                }
                case "virtual-meta-data": {
                    if (this.curDataSource == null) break;
                    reader.setListener(this.curDataSource.getVirtualModel().getModelParser());
                }
            }
        }

        public void saxText(SAXReader reader, String data) {
            if (this.isDescription && this.curDataSource != null) {
                this.curDataSource.setDescription(data);
            } else if (this.curCommand != null) {
                this.curCommand.setCommand(data);
                this.curCommand = null;
            } else if (this.curQuery != null) {
                this.curQuery.append(data);
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "data-source": {
                    this.curDataSource = null;
                    break;
                }
                case "network-handler": {
                    this.curNetworkHandler = null;
                    break;
                }
                case "filter": {
                    this.curFilter = null;
                    break;
                }
                case "query": {
                    if (this.curDataSource == null || this.curQuery == null || this.curQuery.length() <= 0) break;
                    this.curDataSource.getConnectionConfiguration().getBootstrap().getInitQueries().add(this.curQuery.toString());
                    this.curQuery = null;
                }
            }
            this.isDescription = false;
        }

        private String[] readSecuredCredentials(Attributes xmlAttrs, DataSourceDescriptor dataSource, String subNode) {
            String[] creds = new String[2];
            DBASecureStorage secureStorage = dataSource.getProject().getSecureStorage();
            try {
                if (secureStorage.useSecurePreferences()) {
                    ISecurePreferences prefNode = dataSource.getSecurePreferences();
                    if (subNode != null) {
                        String[] stringArray = subNode.split("/");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String nodeName = stringArray[n2];
                            prefNode = prefNode.node(nodeName);
                            ++n2;
                        }
                    }
                    creds[0] = prefNode.get("user", null);
                    creds[1] = prefNode.get("password", null);
                }
            }
            catch (Throwable e) {
                log.error((Object)"Can't read password from secure storage", e);
                this.passwordReadCanceled = true;
            }
            if (CommonUtils.isEmpty((String)creds[0])) {
                creds[0] = xmlAttrs.getValue("user");
            }
            if (CommonUtils.isEmpty((String)creds[1])) {
                String encPassword = xmlAttrs.getValue("password");
                creds[1] = CommonUtils.isEmpty((String)encPassword) ? null : DataSourceSerializerLegacy.decryptPassword(encPassword);
            }
            return creds;
        }
    }
}

