/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.generator;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.ViewSQLDialog;
import org.jkiss.utils.CommonUtils;

class SQLGeneratorDialog
extends ViewSQLDialog {
    private static final String PROP_USE_FQ_NAMES = "GenerateSQL.useFQNames";
    private static final String PROP_USE_COMPACT_SQL = "GenerateSQL.compactSQL";
    private final SQLGenerator<?> sqlGenerator;

    SQLGeneratorDialog(IWorkbenchPartSite parentSite, DBCExecutionContext context, SQLGenerator<?> sqlGenerator) {
        super(parentSite, () -> context, "Generated SQL (" + context.getDataSource().getContainer().getName() + ")", null, "");
        this.sqlGenerator = sqlGenerator;
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        this.sqlGenerator.setFullyQualifiedNames(this.getDialogBoundsSettings().get(PROP_USE_FQ_NAMES) == null || this.getDialogBoundsSettings().getBoolean(PROP_USE_FQ_NAMES));
        this.sqlGenerator.setCompactSQL(this.getDialogBoundsSettings().get(PROP_USE_COMPACT_SQL) != null && this.getDialogBoundsSettings().getBoolean(PROP_USE_COMPACT_SQL));
        UIUtils.runInUI(this.sqlGenerator);
        Object sql = this.sqlGenerator.getResult();
        if (sql != null) {
            this.setSQLText(CommonUtils.toString((Object)sql));
        }
        Composite composite = super.createDialogArea(parent);
        Group settings = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)2, (int)768, (int)-1);
        final Button useFQNames = UIUtils.createCheckbox((Composite)settings, (String)"Use fully qualified names", (boolean)this.sqlGenerator.isFullyQualifiedNames());
        useFQNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLGeneratorDialog.this.sqlGenerator.setFullyQualifiedNames(useFQNames.getSelection());
                SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_USE_FQ_NAMES, useFQNames.getSelection());
                UIUtils.runInUI((DBRRunnableWithProgress)SQLGeneratorDialog.this.sqlGenerator);
                Object sql = SQLGeneratorDialog.this.sqlGenerator.getResult();
                if (sql != null) {
                    SQLGeneratorDialog.this.setSQLText(CommonUtils.toString((Object)sql));
                    SQLGeneratorDialog.this.updateSQL();
                }
            }
        });
        final Button useCompactSQL = UIUtils.createCheckbox((Composite)settings, (String)"Compact SQL", (boolean)this.sqlGenerator.isCompactSQL());
        useCompactSQL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLGeneratorDialog.this.sqlGenerator.setCompactSQL(useCompactSQL.getSelection());
                SQLGeneratorDialog.this.getDialogBoundsSettings().put(SQLGeneratorDialog.PROP_USE_COMPACT_SQL, useCompactSQL.getSelection());
                UIUtils.runInUI((DBRRunnableWithProgress)SQLGeneratorDialog.this.sqlGenerator);
                Object sql = SQLGeneratorDialog.this.sqlGenerator.getResult();
                if (sql != null) {
                    SQLGeneratorDialog.this.setSQLText(CommonUtils.toString((Object)sql));
                    SQLGeneratorDialog.this.updateSQL();
                }
            }
        });
        return composite;
    }
}

